/* ***************************************************************************************
* FILE:          AddChecker.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddChecker is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AddChecker.h"

using namespace FeatStd;

static const FeatStd::UInt8 MAX_NUMBER_OF_ZERO_SIZED_ITEMS = 10;
static const FeatStd::UInt8 MAX_NUMBER_OF_ADDED_ITEMS = 20;


AddChecker::AddChecker(const bool pixelWiseEnabled, const FeatStd::UInt32 configuredNumberOfItems) :
   _pixelWiseEnabled(pixelWiseEnabled),
   _configuredNumberOfItems(configuredNumberOfItems)
{
}


bool AddChecker::ShouldAdd(const ItemAdder& itemAdder, const bool vacantVisibleArea, const bool nextItemSizeZero) const
{
   bool shouldAdd(false);

   const Int32 addedItems(itemAdder.GetNumberOfAddedItems());
   const Candera::UInt32 scrollingIncrement(itemAdder.GetScrollingIncrement());

   if (_pixelWiseEnabled || (0 == _configuredNumberOfItems))
   {
      shouldAdd = (vacantVisibleArea || nextItemSizeZero);
   }
   else if (0 != scrollingIncrement)
   {
      UInt32 addedLines = UInt32(addedItems) / scrollingIncrement;

      shouldAdd = (addedLines < _configuredNumberOfItems);
   }
   else
   {
      //do nothing
   }

   const FeatStd::Int32 zeroSizedElements(itemAdder.GetZeroSizedItems());
   const FeatStd::Int32 sizeOfAddedItems(itemAdder.GetSizeOfAddedElements());

   shouldAdd = shouldAdd && (zeroSizedElements <= MAX_NUMBER_OF_ZERO_SIZED_ITEMS);
   shouldAdd = shouldAdd && ((sizeOfAddedItems > 0) || (addedItems < MAX_NUMBER_OF_ADDED_ITEMS));

   return shouldAdd;
}
