/* ***************************************************************************************
* FILE:          MarginPropertySetter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MarginPropertySetter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(MarginPropertySetter_H)
#define MarginPropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseNode2DPropertySetter.h>

class MarginPropertySetter : public Candera::Animation::BaseNode2DPropertySetter
{
   public:
      typedef Candera::Animation::BaseNode2DPropertySetter Base;

      static MarginPropertySetter* Create(Candera::Node2D* node);

      virtual void Set(const Candera::Float* value);

   private:
      CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, MarginPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
      MarginPropertySetter();
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MarginPropertySetter);
      FEATSTD_SHARED_POINTER_DECLARATION();
};


#endif
