/* ***************************************************************************************
* FILE:          FlexListLimiterAnimationFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexListLimiterAnimationFactory is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef FLEX_LIST_LIMITER_ANIMATION_FACTORY_H
#define FLEX_LIST_LIMITER_ANIMATION_FACTORY_H

#include <Candera/Engine2D/Engine2D.h>
#include <Candera/EngineBase/Animation/AnimationKeyframeSequence.h>

#include "AnimationFactory.h"
#include "MarginPropertySetter.h"


#include <Candera/EngineBase/Animation/EaseInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/BackEaseFunction.h>
#include <Candera/EngineBase/Animation/AnimationBlendedProperty.h>


class FlexListMarginBounceAnimationFactory : public AnimationFactory
{
   public:
      typedef AnimationFactory Base;

      static Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> Create(Candera::Node2D* node, Candera::UInt32 durationMs, Candera::Vector2 bounceDirection);

   private:

      static Candera::Animation::SequenceTimeType* ComputeKeyFrameTimes(Candera::UInt32 durationMs);

      static Candera::Float* ComputeKeyFrameValues(Candera::Node2D* node, Candera::Vector2 bounceDirection);

      static void Dispose(Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer>& result, Candera::Animation::AnimationController*& animationController,
                          const Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence>& keyFrameSequence,
                          Candera::Float*& keyFrameValues, Candera::Animation::SequenceTimeType*& keyFrameTimes, Candera::Animation::EaseInterpolationStrategy*& interpolationStrategy,
                          Candera::Animation::BackEaseFunction*& easeFunction, const Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationBlendedProperty>& blendedProperty, MarginPropertySetter*& marginPropertySetter);
};


#endif
