/* ***************************************************************************************
* FILE:          MarginWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MarginWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(MarginWidget2D_H)
#define MarginWidget2D_H

#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/Layout/generated/MarginWidget2DBase.h"

class MarginWidget2D : public MarginWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(MarginWidget2D, MarginWidget2DBase);

      MarginWidget2D();
      virtual ~MarginWidget2D();

      virtual void Update();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      CdaWidget2DDef(MarginWidget2D, MarginWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 /*propertyId*/);

      virtual void OnNodeChanged();

   private:
      bool _invalid;
};


#endif
