/* ***************************************************************************************
* FILE:          LabelWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LabelWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(LabelWidget2D_H)
#define LabelWidget2D_H

#include "CanderaPlatform/Device/Common/Effects/TextBrushBlend.h"
#include "Candera/System/GlobalizationBase/CultureManager.h"
#include "Candera/Engine2D/Core/TextNode2D.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/Label/generated/LabelWidget2DBase.h"


class LabelWidget2D : public LabelWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      LabelWidget2D();
      virtual ~LabelWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(LabelWidget2D, LabelWidget2DBase);

      typedef Candera::MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> SharedStylePointer;

      virtual void InitWidget();
      virtual void CultureChanged();
      virtual void Update();

      virtual void OnChanged(::FeatStd::UInt32 propertyId);
      virtual bool OnMessage(const Message& msg);
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   public:
      CdaWidget2DDef(LabelWidget2D, LabelWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      void SetDirty()
      {
         _dirty = true;
      }

      void ResetDirty()
      {
         _dirty = false;
      }

      bool IsDirty() const
      {
         return _dirty || (GetText().HasChanged()) || (GetTruncationText().HasChanged());
      }

   private:
      Candera::TextNode2D* _textNode;
      bool _dirty;
};


#endif
