/* ***************************************************************************************
* FILE:          ImageSwitchWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ImageSwitchWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ImageSwitch_WIDGET2D_H
#define ImageSwitch_WIDGET2D_H

#include "Widgets/2D/ImageSwitch/generated/ImageSwitchWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

/* This widget allows to set the image of bitmap brush based on an index.
*/
class ImageSwitchWidget2D : public ImageSwitchWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
#define DefBitmapProperty(index) \
      const BitmapType& GetBitmap##index() const { return GetBitmap(index); } \
      void SetBitmap##index(const BitmapType& bitmap) { SetBitmap(index, bitmap); } \
      bool ShowBitmap##index() const { return IsBitmapPropertyVisible(index); }

#define DefBitmapProperty10(mult) \
      DefBitmapProperty(mult##0) \
      DefBitmapProperty(mult##1) \
      DefBitmapProperty(mult##2) \
      DefBitmapProperty(mult##3) \
      DefBitmapProperty(mult##4) \
      DefBitmapProperty(mult##5) \
      DefBitmapProperty(mult##6) \
      DefBitmapProperty(mult##7) \
      DefBitmapProperty(mult##8) \
      DefBitmapProperty(mult##9)

#define CdaBitmapProperty(index) \
      CdaProperty(Bitmap##index, BitmapType, GetBitmap##index, SetBitmap##index) \
         CdaDescription("Bitmap to be set on the existing BitmapBrushEffect of the associated RenderNode.") \
         CdaVisibilityTest(ShowBitmap##index) \
      CdaPropertyEnd()

#define MAX_BITMAP_COUNT 100

   public:
      typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> BitmapType;

      ImageSwitchWidget2D();
      virtual ~ImageSwitchWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ImageSwitchWidget2D, ImageSwitchWidget2DBase);

      /* Returns the bitmap for the specified index. If the index is greater or equal to the number of bitmaps an empty shared pointer is returned. */
      const BitmapType& GetBitmap(IndexType index) const;
      /* Modifies the bitmap for the specified index. */
      void SetBitmap(IndexType index, const BitmapType& bitmap);
      /* Returns true if the specified index is lower than the number of bitmaps. */
      bool IsBitmapPropertyVisible(IndexType index) const;

      DefBitmapProperty(0)
      DefBitmapProperty(1)
      DefBitmapProperty(2)
      DefBitmapProperty(3)
      DefBitmapProperty(4)
      DefBitmapProperty(5)
      DefBitmapProperty(6)
      DefBitmapProperty(7)
      DefBitmapProperty(8)
      DefBitmapProperty(9)

      DefBitmapProperty10(1)
      DefBitmapProperty10(2)
      DefBitmapProperty10(3)
      DefBitmapProperty10(4)
      DefBitmapProperty10(5)
      DefBitmapProperty10(6)
      DefBitmapProperty10(7)
      DefBitmapProperty10(8)
      DefBitmapProperty10(9)

      CdaWidget2DDef(ImageSwitchWidget2D, ImageSwitchWidget2DBase)
      CdaProperties()

      CdaBitmapProperty(0)
      CdaBitmapProperty(1)
      CdaBitmapProperty(2)
      CdaBitmapProperty(3)
      CdaBitmapProperty(4)
      CdaBitmapProperty(5)
      CdaBitmapProperty(6)
      CdaBitmapProperty(7)
      CdaBitmapProperty(8)
      CdaBitmapProperty(9)

      CdaBitmapProperty(10)
      CdaBitmapProperty(11)
      CdaBitmapProperty(12)
      CdaBitmapProperty(13)
      CdaBitmapProperty(14)
      CdaBitmapProperty(15)
      CdaBitmapProperty(16)
      CdaBitmapProperty(17)
      CdaBitmapProperty(18)
      CdaBitmapProperty(19)

      CdaBitmapProperty(20)
      CdaBitmapProperty(21)
      CdaBitmapProperty(22)
      CdaBitmapProperty(23)
      CdaBitmapProperty(24)
      CdaBitmapProperty(25)
      CdaBitmapProperty(26)
      CdaBitmapProperty(27)
      CdaBitmapProperty(28)
      CdaBitmapProperty(29)

      CdaBitmapProperty(30)
      CdaBitmapProperty(31)
      CdaBitmapProperty(32)
      CdaBitmapProperty(33)
      CdaBitmapProperty(34)
      CdaBitmapProperty(35)
      CdaBitmapProperty(36)
      CdaBitmapProperty(37)
      CdaBitmapProperty(38)
      CdaBitmapProperty(39)

      CdaBitmapProperty(40)
      CdaBitmapProperty(41)
      CdaBitmapProperty(42)
      CdaBitmapProperty(43)
      CdaBitmapProperty(44)
      CdaBitmapProperty(45)
      CdaBitmapProperty(46)
      CdaBitmapProperty(47)
      CdaBitmapProperty(48)
      CdaBitmapProperty(49)

      CdaBitmapProperty(50)
      CdaBitmapProperty(51)
      CdaBitmapProperty(52)
      CdaBitmapProperty(53)
      CdaBitmapProperty(54)
      CdaBitmapProperty(55)
      CdaBitmapProperty(56)
      CdaBitmapProperty(57)
      CdaBitmapProperty(58)
      CdaBitmapProperty(59)

      CdaBitmapProperty(60)
      CdaBitmapProperty(61)
      CdaBitmapProperty(62)
      CdaBitmapProperty(63)
      CdaBitmapProperty(64)
      CdaBitmapProperty(65)
      CdaBitmapProperty(66)
      CdaBitmapProperty(67)
      CdaBitmapProperty(68)
      CdaBitmapProperty(69)

      CdaBitmapProperty(70)
      CdaBitmapProperty(71)
      CdaBitmapProperty(72)
      CdaBitmapProperty(73)
      CdaBitmapProperty(74)
      CdaBitmapProperty(75)
      CdaBitmapProperty(76)
      CdaBitmapProperty(77)
      CdaBitmapProperty(78)
      CdaBitmapProperty(79)

      CdaBitmapProperty(80)
      CdaBitmapProperty(81)
      CdaBitmapProperty(82)
      CdaBitmapProperty(83)
      CdaBitmapProperty(84)
      CdaBitmapProperty(85)
      CdaBitmapProperty(86)
      CdaBitmapProperty(87)
      CdaBitmapProperty(88)
      CdaBitmapProperty(89)

      CdaBitmapProperty(90)
      CdaBitmapProperty(91)
      CdaBitmapProperty(92)
      CdaBitmapProperty(93)
      CdaBitmapProperty(94)
      CdaBitmapProperty(95)
      CdaBitmapProperty(96)
      CdaBitmapProperty(97)
      CdaBitmapProperty(98)
      CdaBitmapProperty(99)

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);
      virtual void Update();
      virtual void OnChanged(Candera::UInt32 propertyId);

      std::vector<BitmapType> _bitmaps;
      bool _invalid;

#undef DefBitmapProperty
#undef DefBitmapProperty10
#undef CdaBitmapProperty
};


#endif //ImageSwitch_WIDGET2D_H
