/* ***************************************************************************************
* FILE:          ImageEffectWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ImageEffectWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ImageEffect_WIDGET2D_H
#define ImageEffect_WIDGET2D_H

#include <Candera/Engine2D/Core/Image2D.h>
#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>
#include <Widgets/2D/ImageEffect/generated/ImageEffectWidget2DBase.h>
#include <Widgets/2D/EffectControl/ColorEffectWidget2D.h>

class ImageEffectWidget2D : public ImageEffectWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ImageEffectWidget2D, ImageEffectWidget2DBase);

      ImageEffectWidget2D();
      virtual ~ImageEffectWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      static void SetImage(BaseWidget2D& widget, const Candera::MemoryManagement::SharedPointer<Candera::Image2D>& image);
      static void SetImage(BaseWidget2D& widget, Candera::BitmapBrush& bitmapBrush, const Candera::MemoryManagement::SharedPointer<Candera::Image2D>& image);

      DefProperty_ColorEffect_Color()

   private:
      virtual void Update();
      virtual void OnNodeChanged()
      {
         _invalid = true;
      }
      virtual void OnChanged(::Candera::UInt32 propertyId);

      bool _invalid;

      CdaWidget2DDef(ImageEffectWidget2D, ImageEffectWidget2DBase)
      CdaProperties()

      CdaProperty_ColorEffect_Color()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
