/* ***************************************************************************************
* FILE:          GridAutoArrangeWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridAutoArrangeWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "GridAutoArrangeWidget2D.h"

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/GridLayouter.h>
#else
#include <Candera/Engine2D/Layout/GridLayouter.h>
#endif


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LAYOUTER
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/GridAutoArrangeWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(GridAutoArrangeWidget2D);


GridAutoArrangeWidget2D::GridAutoArrangeWidget2D(): Base()
{
}


GridAutoArrangeWidget2D::~GridAutoArrangeWidget2D()
{
}


void GridAutoArrangeWidget2D::Update()
{
   if ((GetNode() != NULL) && (GetNode()->GetChildCount() > 0))
   {
      Candera::GridLayouter* grid = dynamic_cast<Candera::GridLayouter*>(GetNode()->GetLayouter());
      if ((grid != NULL) && (grid->GetColumnCount() > 0))
      {
         bool invalidate = false;
         Candera::UInt16 index = 0;
         Candera::UInt8 columnCount = grid->GetColumnCount();
         for (Candera::Node2D* child = GetNode()->GetFirstChild(); child != NULL; child = child->GetNextSibling())
         {
            Candera::UInt8 column = static_cast<Candera::UInt8>(index % columnCount);
            if (Candera::GridLayouter::GetColumn(*child) != column)
            {
               Candera::GridLayouter::SetColumn(*child, column);
               invalidate = true;
            }

            Candera::UInt8 row = static_cast<Candera::UInt8>(index / columnCount);
            if (Candera::GridLayouter::GetRow(*child) != row)
            {
               Candera::GridLayouter::SetRow(*child, row);
               invalidate = true;
            }
            index++;
         }
         if (invalidate)
         {
            Invalidate();
         }
      }
   }
}
