/* ***************************************************************************************
* FILE:          GizmoWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GizmoWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Gizmo_WIDGET2D_H
#define Gizmo_WIDGET2D_H

#include <Widgets/2D/Gizmo/generated/GizmoWidget2DBase.h>
#include "GizmoController2D.h"

namespace hmibase {
namespace widget {
namespace flags {
enum Enum_Gizmo2D
{
   OwnedByPageEdit = _LastValue_Touchable2D,

   //last value
   _LastValue_Gizmo2D
};


}
namespace gizmo {


/*****************************************************************************/
/*
* GizmoWidget2D provides support to move, resize and rotate nodes.
* The term Gizmo denotes a bounding box used for manipulating objects in 3D modelling computer programs.

* GizmoWidget2D is a delegate widget and its behavior is controlled by a widget controller attached using the property ControllerId.
* See the DelegateWidget2D chapter for information regarding how to work with widget controllers.
* The default value 0 for the ControllerId will cause the default gizmo controller to be used.
*/
class GizmoWidget2D : public GizmoWidget2DBase
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(GizmoWidget2D, GizmoWidget2DBase);

      /*****************************************************************************/
      GizmoWidget2D();
      virtual ~GizmoWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      virtual hmibase::widget::WidgetController* GetDefaultController() const override;

      DefWidgetFlag(OwnedByPageEdit, 0)

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(GizmoWidget2D, GizmoWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      /*****************************************************************************/
      /* Visibility of scene composer properties */
      virtual bool isPositionPropertyVisible() const override
      {
         return true;
      }
      virtual bool isSizePropertyVisible() const override
      {
         return true;
      }
      virtual bool isRotationPropertyVisible() const override
      {
         return true;
      }
};


}
}


}


HMIBASE_DEPRECATED_TYPE_ALIAS(GizmoWidget2D, hmibase::widget::gizmo::GizmoWidget2D);


#endif
