/* ***************************************************************************************
* FILE:          FocusUtils2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusUtils2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "FocusUtils2D.h"
#include "FocusGroupWidget2D.h"
#include "Focus/FCommon.h"
#include "Focus/FConfigInfo.h"
#include "Focus/FDataSet.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/Default/FDefaultAnimationManager.h"
#include "Widgets/2D/WidgetFinder2D.h"
#include "Widgets/2D/Button/ButtonWidget2D.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FocusUtils2D.cpp.trc.h"
#endif


bool FocusUtils::setFocusOnDescendent(Candera::Scene2DContext*, Candera::Node2D*)
{
   //deprecated
   return false;
}


Focus::FWidgetConfig* FocusUtils::getFocusableHandle(BaseWidget2D& widget)
{
   Focus::FWidgetConfig* handle = NULL;
   if (widget.GetParentView() != NULL)
   {
      Focus::FManager& focusManager = Focus::FManager::getInstance();
      handle = focusManager.getHandle(widget.GetParentView()->GetId(), widget.GetLegacyName());
   }
   return handle;
}


bool FocusUtils::isFocused(BaseWidget2D& widget)
{
   Focus::FAppStateSharedPtr crtAppState = Focus::FManager::getInstance().getCurrentAppState();
   if (Focus::FManager::getInstance().isFocusVisible()
         && (widget.GetParentView() != NULL) && !crtAppState.PointsToNull()
         && (crtAppState->CurrentFocusInfo.ViewId == widget.GetParentView()->GetId())
         && (crtAppState->CurrentFocusInfo.WidgetId == widget.GetLegacyName()))
   {
      return true;
   }

   return false;
}


bool FocusUtils::isFocusGroup(BaseWidget2D& widget)
{
   return dynamic_cast<FocusGroupBase*>(&widget) != NULL;
}
