/* ***************************************************************************************
* FILE:          ColorEffectWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ColorEffectWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ColorEffect_WIDGET2D_H
#define ColorEffect_WIDGET2D_H

#include <Widgets/utils/EffectUtils.h>
#include <Widgets/2D/EffectControl/generated/ColorEffectWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>

class Effect2D;


#define DefProperty_ColorEffect_Color()\
      void setColor(const hmibase::widget::utils::EffectUtils::ColorType& value)\
      {\
         if (hmibase::widget::utils::EffectUtils::setColor(GetNode(), value))\
         {\
            Invalidate();\
         }\
      }\
      hmibase::widget::utils::EffectUtils::ColorType getColor() const { return hmibase::widget::utils::EffectUtils::getColor(GetNode()); }\
      bool isColorPropertyVisible() const { return hmibase::widget::utils::EffectUtils::getColorProperty(GetNode()) != NULL; }

#define CdaProperty_ColorEffect_Color()\
      CdaBindableProperty(Color, hmibase::widget::utils::EffectUtils::ColorType, getColor, setColor)\
         CdaDescription("Color to be set on the effect of the RenderNode.")\
         CdaVisibilityTest(isColorPropertyVisible)\
      CdaBindablePropertyEnd()


class ColorEffectWidget2D : public ColorEffectWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ColorEffectWidget2D, ColorEffectWidget2DBase);

      ColorEffectWidget2D();
      virtual ~ColorEffectWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      DefProperty_ColorEffect_Color()

   private:
      CdaWidget2DDef(ColorEffectWidget2D, ColorEffectWidget2DBase)
      CdaProperties()

      CdaProperty_ColorEffect_Color()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
