/* ***************************************************************************************
* FILE:          EditFieldHelpers.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EditFieldHelpers is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HTC_EditField_Helpers_H
#define HTC_EditField_Helpers_H

#define EF_MIN_TEXT_LENGTH            0
#define EF_MAX_TEXT_LENGTH            255    // Maximum number of UTF8 Characters

class CursorPosition
{
   public:
      CursorPosition(Candera::UInt32 minIndex);

      void SetCursorIndex(const Candera::UInt32& index);
      void SetDisplayedCursorIndex(const Candera::UInt32& index);

      const Candera::UInt32& GetCursorIndex() const;
      const Candera::UInt32& GetDisplayedCursorIndex() const;

      void ShiftLeft(const Candera::UInt32& pos);
      void ShiftRight(const Candera::UInt32& pos);

      void operator--(int);
      void operator--();
      void operator++(int);
      void operator++();

   private:
      Candera::UInt32 m_u8CursorIndex;
      Candera::UInt32 m_u8DisplayedCursorIndex;
}; //lint !e1758


#endif // HTC_EditField_Helpers_H
