/* ***************************************************************************************
* FILE:          EditFieldHelpers.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EditFieldHelpers is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "EditFieldHelpers.h"

using namespace Courier;

CursorPosition::CursorPosition(Candera::UInt32 minIndex)
{
   m_u8CursorIndex = minIndex;
   m_u8DisplayedCursorIndex = minIndex;
}


void CursorPosition::SetCursorIndex(const Candera::UInt32& index)
{
   m_u8CursorIndex = index;
}


void CursorPosition::SetDisplayedCursorIndex(const Candera::UInt32& index)
{
   m_u8DisplayedCursorIndex = index;
}


const Candera::UInt32& CursorPosition::GetCursorIndex() const
{
   return m_u8CursorIndex;
}


const Candera::UInt32& CursorPosition::GetDisplayedCursorIndex() const
{
   return m_u8DisplayedCursorIndex;
}


void CursorPosition::operator--(int)
{
   FEATSTD_DEBUG_ASSERT(m_u8CursorIndex > EF_MIN_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT(m_u8DisplayedCursorIndex > EF_MIN_TEXT_LENGTH);
   --m_u8CursorIndex;
   --m_u8DisplayedCursorIndex;
}


void CursorPosition::operator--()
{
   FEATSTD_DEBUG_ASSERT(m_u8CursorIndex > EF_MIN_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT(m_u8DisplayedCursorIndex > EF_MIN_TEXT_LENGTH);
   --m_u8CursorIndex;
   --m_u8DisplayedCursorIndex;
}


void CursorPosition::operator++(int)
{
   FEATSTD_DEBUG_ASSERT(m_u8CursorIndex < EF_MAX_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT(m_u8DisplayedCursorIndex < EF_MAX_TEXT_LENGTH);
   ++m_u8CursorIndex;
   ++m_u8DisplayedCursorIndex;
}


void CursorPosition::operator++()
{
   FEATSTD_DEBUG_ASSERT(m_u8CursorIndex < EF_MAX_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT(m_u8DisplayedCursorIndex < EF_MAX_TEXT_LENGTH);
   ++m_u8CursorIndex;
   ++m_u8DisplayedCursorIndex;
}


void CursorPosition::ShiftLeft(const Candera::UInt32& pos)
{
   FEATSTD_DEBUG_ASSERT((m_u8CursorIndex - pos) >= EF_MIN_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT((m_u8DisplayedCursorIndex - pos) >= EF_MIN_TEXT_LENGTH);
   m_u8CursorIndex -= pos;
   m_u8DisplayedCursorIndex -= pos;
}


void CursorPosition::ShiftRight(const Candera::UInt32& pos)
{
   FEATSTD_DEBUG_ASSERT((m_u8CursorIndex + pos) <= EF_MAX_TEXT_LENGTH);
   FEATSTD_DEBUG_ASSERT((m_u8DisplayedCursorIndex + pos) <= EF_MAX_TEXT_LENGTH);
   m_u8CursorIndex += pos;
   m_u8DisplayedCursorIndex += pos;
}
