/* ***************************************************************************************
* FILE:          DDModelBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DDModelBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_DRAG_DROP_MODEL_BASE_H)
#define _DRAG_DROP_MODEL_BASE_H

#include "hmi_trace_if.h"
#include "BaseContract/generated/BaseMsgs.h"
#include "View/CGI/CgiExtensions/CourierMessageMapper.h"

namespace DragDrop {
class DDModelBase
{
   public:
      DDModelBase();
      virtual ~DDModelBase();

      virtual bool onCourierMessage(const DragDropCheckSourceReqMsg& msg);
      void sendCheckSourceRes(FeatStd::UInt32 reqId, FeatStd::UInt32 sourceData, bool result);

      virtual bool onCourierMessage(const DragDropCheckDestinationReqMsg& msg);
      void sendCheckDestinationRes(FeatStd::UInt32 reqId, FeatStd::UInt32 destinationData, bool result);

      virtual bool onCourierMessage(const DragDropCompleteReqMsg& msg);
      void sendCompleteRes(FeatStd::UInt32 reqId, bool result);

      virtual bool onCourierMessage(const DragDropStatusUpdMsg& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_FW_DRAG_DROP)
      ON_COURIER_MESSAGE(DragDropCheckSourceReqMsg)
      ON_COURIER_MESSAGE(DragDropCheckDestinationReqMsg)
      ON_COURIER_MESSAGE(DragDropCompleteReqMsg)
      ON_COURIER_MESSAGE(DragDropStatusUpdMsg)
      COURIER_MSG_MAP_END()

   protected:
      virtual bool isValidSource(const DragDropCheckSourceReqMsg& msg) = 0;
      virtual bool isValidDestination(const DragDropCheckDestinationReqMsg& msg) = 0;
      virtual bool executeDrop(const DragDropCompleteReqMsg& msg) = 0;
};


}
#endif//_DRAG_DROP_MODEL_BASE_H
