/* ***************************************************************************************
* FILE:          DDAdorner.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DDAdorner is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_DRAG_DROP_ADORNER_H)
#define _DRAG_DROP_ADORNER_H

namespace Candera {
class Widget2D;
class Node2D;
}


namespace Courier {
class View;
}


class BaseWidget2D;

namespace DragDrop {
class DDAdorner
{
   public:
      DDAdorner();
      virtual ~DDAdorner();

      void create(BaseWidget2D& widget, const Courier::TouchInfo& touchInfo);
      void destroy();

      void show();
      void hide();

      void move(const Courier::TouchInfo& touchInfo);

      bool isVisible() const
      {
         return _visible;
      }

      void onNodeDeleted(const Candera::Node2D* node);

   private:
      DDAdorner(const DDAdorner&);
      DDAdorner& operator=(const DDAdorner&);

      bool _visible;
      Candera::Node2D* _node;
      Courier::View* _view;
      Courier::TouchInfo _touchInfo;
};


}
#endif//_DRAG_DROP_ADORNER_H
