/* ***************************************************************************************
* FILE:          DockSideWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DockSideWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "Widgets/2D/Common/NodeHelper.h"

#include "DockSideWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(DockSideWidget2D);


DockSideWidget2D::DockSideWidget2D() : _invalid(true)
{
}


DockSideWidget2D::~DockSideWidget2D()
{
}


bool DockSideWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const DockSideWidget2D* original = CLONEABLE_WIDGET_CAST<const DockSideWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());
      SetDockSide(original->GetDockSide());

      cloned = true;
   }
   return cloned;
}


void DockSideWidget2D::Update()
{
   if (_invalid && (0 != GetNode()))
   {
      Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
      if (0 != node)
      {
         static_cast<void>(Candera::DockPanelLayouter::SetDockSide(*node, GetDockSide()));
         Invalidate();
         _invalid = false;
      }
   }
}


void DockSideWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);
   _invalid = true;
}


void DockSideWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}
