/* ***************************************************************************************
* FILE:          DirectTextureProvider2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DirectTextureProvider2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DirectTextureProvider2D_h)
#define DirectTextureProvider2D_h

#include <Candera/Engine3D/Core/TextureImage.h>
#include "Widgets/2D/DirectTextureProvider/generated/DirectTextureProvider2DBase.h"
#include <Candera/Engine2D/Core/Camera2DListener.h>

#include "Gadget/SyncBlockProducerFactory.h"

#include "View/CGI/CgiExtensions/RenderJobStrategy.h"

namespace Candera {
class GeniviFrameBufferObject;
}


namespace syncblock {
class Producer;
}


namespace hmibase {
namespace gadget {
namespace videobuffer {
class VideoBufferType;
}


}
}


class DirectTextureProvider2D : public DirectTextureProvider2DBase, public hmibase::gadget::SyncBlockProducerFactory::Accessor, public hmibase::view::RenderJobStrategy::RenderJobListener
{
   public:
      DirectTextureProvider2D();
      virtual ~DirectTextureProvider2D();

      CGI_WIDGET_RTTI_DECLARATION(DirectTextureProvider2D, DirectTextureProvider2DBase);

      virtual void InitWidget(); // override
      virtual void Update();

      virtual void OnParentViewLoad(bool load);

      virtual void OnParentViewActivate(bool active);

      virtual void OnPostSwapBuffer(Courier::Gdu& gdu);

      virtual bool IsVirtuallyTouched(FeatStd::UInt32 instanceId)
      {
         return (GetInstanceId() == instanceId);
      }

      CdaWidget2DDef(DirectTextureProvider2D, DirectTextureProvider2DBase)
      CdaDescription("DirectTextureProvider2D")
      CdaReadableName("DirectTextureProvider2D")
      CdaCategory("DirectTexture")

      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:

      class DebugUtil
      {
         public:
            static void Capture(unsigned int instanceId, hmibase::gadget::videobuffer::VideoBufferType* buffer, Courier::ViewId viewName);
         private:
            static bool s_initialized;
            static std::set<unsigned int> s_instanceIdsToDebug;
      };

      typedef Candera::MemoryManagement::SharedPointer<Candera::TextureImage> TextureImageSharedPointer;
      typedef std::map<int, std::pair<TextureImageSharedPointer, const Candera::Camera2D*> > DirectTextureMap;

      void FboUpload(Candera::GeniviFrameBufferObject* fbo, TextureImageSharedPointer directTexture);
      void ToggleCamera(const Candera::Camera2D* camera);
      void InitSyncBlock();

      DirectTextureMap _directTexturerMap;
      hmibase::gadget::videobuffer::VideoBufferType* _lastExchangedBuffer;

      enum Mode
      {
         INVALID,
         SINGLEBUFFERED,
         TRIPLEBUFFERED
      };
      Mode _mode;

      unsigned int _syncBlockId;

      Candera::Camera2D* _nextCamera;
      bool _initialBufferUpload;

      std::map<int, int> myMap;
};


#endif // DirectTextureProvider2D_h
