/* ***************************************************************************************
* FILE:          DelegateWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DelegateWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/Delegate/generated/DelegateWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <View/CGI/Widget/WidgetController.h>

namespace hmibase {
namespace widget {

/*****************************************************************************/
class DelegateWidget2D : public DelegateWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
      /*****************************************************************************/
   public:
      CGI_WIDGET_RTTI_DECLARATION(DelegateWidget2D, DelegateWidget2DBase);

      DelegateWidget2D();
      virtual ~DelegateWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(DelegateWidget2D, DelegateWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      /*****************************************************************************/
      /* Visibility of scene composer properties */
      virtual bool composerPropVisibleFilter_Enabled() const override
      {
         return true;
      }
};


}
}
