/* ***************************************************************************************
* FILE:          ViewWidgetEnumerator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewWidgetEnumerator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ViewWidgetEnumerator_H)
#define ViewWidgetEnumerator_H

#include "TConvertingVectorEnumerator.h"
#include <CanderaWidget/WidgetBase/WidgetBase.h>
#include <Candera/Engine2D/Core/Node2D.h>

class ViewWidgetEnumerator : public TConvertingVectorEnumerator<Candera::WidgetBase*, Courier::FrameworkWidget*>
{
   public:
      typedef TConvertingVectorEnumerator<Candera::WidgetBase*, Courier::FrameworkWidget*> Base;

      ViewWidgetEnumerator(const Courier::Vector<Courier::FrameworkWidget*>& widgets, const Candera::Node2D& node);

      virtual bool MoveNext();

      bool IsMatch(const Candera::WidgetBase* widgetBase) const;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ViewWidgetEnumerator);
      FEATSTD_LINT_NEXT_EXPRESSION(1704, "make default constructor private")
      ViewWidgetEnumerator();
      const Candera::Node2D& _node;
};


#endif
