/* ***************************************************************************************
* FILE:          ViewWidgetEnumerator.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewWidgetEnumerator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplateWidget2D.h"

#include "ViewWidgetEnumerator.h"


bool ViewWidgetEnumerator::MoveNext()
{
   while (Base::MoveNext())
   {
      if (IsMatch(Current()))
      {
         return true;
      }
   }
   _current = 0;
   return false;
}


bool ViewWidgetEnumerator::IsMatch(const Candera::WidgetBase* widgetBase) const
{
   return (0 != widgetBase) && (widgetBase->GetNode2D() == &_node) && (0 == CLONEABLE_WIDGET_CAST<const ControlTemplateWidget2D*>(widgetBase));
}


ViewWidgetEnumerator::ViewWidgetEnumerator(const Courier::Vector<Courier::FrameworkWidget*>& widgets, const Candera::Node2D& node) :
   Base(widgets),
   _node(node)
{
}
