/* ***************************************************************************************
* FILE:          SourceItem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SourceItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SourceItem_H)
#define SourceItem_H

#include <CanderaPlatform/OS/CanderaTypes.h>
#include <CanderaWidget/String/String.h>
#include "DataItem.h"

namespace gccSpecializationHelper {
template<typename T> struct SourceItem;
template<> struct SourceItem<bool>
{
   static bool Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex);
};


template<> struct SourceItem<Candera::Int32>
{
   static Candera::Int32 Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex);
};


template<> struct SourceItem<Candera::String>
{
   static Candera::String Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex);
};


}

#endif
