/* ***************************************************************************************
* FILE:          ReuseCloneCachingStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ReuseCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplate.h"
#include <Courier/Visualization/ViewScene2D.h>

#include "ReuseCloneCachingStrategy.h"
#include <Widgets/2D/ControlTemplate/CloneEvents.h>

#include "hmi_trace_if.h"
#include "Widgets/widget_etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ReuseCloneCachingStrategy.cpp.trc.h"
#endif

#include "CloneCachingStrategyHelper.h"

ReuseCloneCachingStrategy::ReuseCloneCachingStrategy() :
   _cacheActive(true)
{
}


ControlTemplateInstancePtr ReuseCloneCachingStrategy::Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations)
{
   ControlTemplateInstancePtr controlTemplateInstance(0);

   ControlTemplateInstanceCache::iterator it = _cache.find(source);
   if (it != _cache.end())
   {
      controlTemplateInstance = it->second;

      ReuseInstanceEvent reuseInstanceEvent(controlTemplateInstance, templateNode, source, owner);

      CloneCachingStrategyHelper().UpdateControlTemplateInstance(controlTemplateInstance, reuseInstanceEvent, templateNode, source, owner, templateAnimations);
   }

   return controlTemplateInstance;
}


void ReuseCloneCachingStrategy::ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 /*index*/)
{
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ReuseCloneCachingStrategy::ProcessAfterCloning cached instance=%p, caceSize=%d", instance.GetPointerToSharedInstance(), _cache.size()));

   Cache(instance.GetPointerToSharedInstance());
}


bool ReuseCloneCachingStrategy::ProcessBeforeDisposed(ControlTemplateInstance* instance)
{
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ReuseCloneCachingStrategy::ProcessBeforeDisposed cached instance=%p, caceSize=%d", instance, _cache.size()));
   return !Cache(instance);
}


bool ReuseCloneCachingStrategy::Cache(ControlTemplateInstance* instance)
{
   bool cached(false);

   if (_cacheActive && (0 != instance) && (0 != instance->GetItemRootNode()))
   {
      Candera::Node2D* itemRootNode(instance->GetItemRootNode());
      tSharedPtrIDataItem dataItem(ControlTemplate::GetDataContext(*itemRootNode, false));
      _cacheActive = false;
      {
         ControlTemplateInstancePtr instancePtr(instance);
         ControlTemplateInstancePtr& mapped(_cache[dataItem]);
         mapped = instancePtr;
      }

      _cacheActive = true;
      cached = true;

      ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ReuseCloneCachingStrategy::Cache cached owner=%p, cti=%p, caceSize=%d", instance->GetOwner(), instance, _cache.size()));
   }

   return cached;
}


void ReuseCloneCachingStrategy::ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex)
{
   ClearCache();
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ReuseCloneCachingStrategy::ProcessBeforeFlush"));
}


void ReuseCloneCachingStrategy::Finalize()
{
   ClearCache();
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ReuseCloneCachingStrategy::Finalize"));
}


void ReuseCloneCachingStrategy::ClearCache()
{
   _cacheActive = false;
   _cache.clear();
   _cacheActive = true;
}
