/* ***************************************************************************************
* FILE:          PrepareClonedItemCachingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PrepareClonedItemCachingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PrepareClonedItemCachingBehavior_H)
#define PrepareClonedItemCachingBehavior_H

#include <Widgets/2D/ControlTemplate/BaseClonedItemCachingBehavior.h>
#include <Widgets/2D/ControlTemplate/PoolCloneCachingStrategy.h>
#include <Widgets/2D/List/Content/ContentProvider.h>
#include <Widgets/2D/List/Content/TemplateRetriever.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateInstanceContainer.h>
#include <Widgets/2D/List/Content/ISizeContainer.h>

class PrepareClonedItemCachingBehavior : public BaseClonedItemCachingBehavior
{
      FEATSTD_TYPEDEF_BASE(BaseClonedItemCachingBehavior);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(PrepareClonedItemCachingBehavior);

      //Clarify: itemInstanceContainer currently only used to retrieve owner and ownerId, kept as not sure if it also should hold the prepared instances
      //if not, it can be replaced with owner and ownerId as own parameters
      PrepareClonedItemCachingBehavior(OwnerInfoRetriever& ownerRetriever,
                                       const ContentProvider& contentProvider,
                                       const ITemplateRetriever& templateRetriever,
                                       BaseWidget2D* owner,
                                       Courier::UInt32 ownerId,
                                       ISizeContainer& sizeContainer,
                                       FeatStd::UInt8 preparedBufferSize,
                                       FeatStd::UInt8 _prepareThreshold);

      virtual ~PrepareClonedItemCachingBehavior();

      virtual void OnPostItemsUpdateFinished(FeatStd::UInt32 firstVisibleIndex, FeatStd::UInt32 lastVisibleIndex) override;
      virtual void OnPostItemsUpdated(FeatStd::UInt32 firstVisibleIndex, FeatStd::UInt32 lastVisibleIndex) override;

      void SetPreparedItemsBufferSize(FeatStd::UInt32 preparedBufferSize)
      {
         _preparedItemBufferSize = preparedBufferSize;
      }
      void SetPrepareThreshold(FeatStd::UInt32 threshold)
      {
         _prepareThreshold = threshold;
      }

   private:
      void PrepareItem(FeatStd::UInt32 index);
      void PrepareItemsUp(FeatStd::UInt32 startIndex, FeatStd::UInt32 noOfItems);
      void PrepareItemsDown(FeatStd::UInt32 startIndex, FeatStd::UInt32 noOfItems);

      PoolCloneCachingStrategy _cachingStrategy;
      const ContentProvider& _contentProvider;
      const ITemplateRetriever& _templateRetriever;
      ISizeContainer& _sizeContainer;
      BaseWidget2D* _owner;
      FeatStd::UInt32 _ownerId;
      FeatStd::UInt32 _preparedItemBufferSize;
      FeatStd::UInt32 _prepareThreshold;
};


#endif
