/* ***************************************************************************************
* FILE:          PoolCloneCachingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PoolCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PoolCloneCachingStrategy_H)
#define PoolCloneCachingStrategy_H

#include "CloneCachingStrategy.h"
#include <Candera/System/Rtti/Rtti.h>
#include <FeatStd/Util/ConvenienceMacros.h>

/**
 * The PoolCloneCachingStrategy will cache ControlTemplateInstances until the next call of Flush.
 */
class PoolCloneCachingStrategy : public CloneCachingStrategy
{
   public:
      PoolCloneCachingStrategy();
      virtual ~PoolCloneCachingStrategy();

      void SetCacheSize(FeatStd::UInt32 cacheSize)
      {
         _cacheSize = cacheSize;
      }

      FeatStd::UInt32 GetFirstCachedIndex();
      FeatStd::UInt32 GetLastCachedIndex();

      FeatStd::UInt32 GetCurrentCacheSize() const
      {
         return _cache.size();
      }

      virtual ControlTemplateInstancePtr Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations) override;
      virtual void ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index) override;
      virtual bool ProcessBeforeDisposed(ControlTemplateInstance* instance) override;
      virtual void ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex) override;
      virtual void Finalize() override;

   private:

      ControlTemplateInstancePtr GetFirstCachedInstance();
      ControlTemplateInstancePtr GetLastCachedInstance();
      void DisposeInstance(ControlTemplateInstancePtr instance);

      typedef std::map<FeatStd::UInt32, ControlTemplateInstancePtr> ControlTemplateInstanceMap;

      ControlTemplateInstanceMap _cache;
      FeatStd::UInt32 _cacheSize;
};


#endif
