/* ***************************************************************************************
* FILE:          OnRequestCloneCachingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OnRequestCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OnRequestCloneCachingStrategy_H)
#define OnRequestCloneCachingStrategy_H

#include "CloneCachingStrategy.h"

/**
 * The OnRequestCloneCachingStrategy will cache ControlTemplateInstance on request
 */
class OnRequestCloneCachingStrategy : public CloneCachingStrategy
{
   public:
      OnRequestCloneCachingStrategy();
      virtual ~OnRequestCloneCachingStrategy();

      void SetOther(CloneCachingStrategy* val)
      {
         _other = val;
      }

      virtual ControlTemplateInstancePtr Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations) override;
      virtual void ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index) override;
      virtual bool ProcessBeforeDisposed(ControlTemplateInstance* instance) override;
      virtual void ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex) override;
      virtual void Finalize() override;

      void Retain(FeatStd::UInt32 index);
      void Release(FeatStd::UInt32 index);

      bool OnMessage(const Courier::Message& msg);
      void Update();

   private:
      typedef std::map<FeatStd::UInt32, ControlTemplateInstancePtr> CTICache;

      CTICache _cache;
      CloneCachingStrategy* _other;
};


#endif
