/* ***************************************************************************************
* FILE:          ItemLayouter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ItemLayouter_H)
#define ItemLayouter_H

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include <Courier/Version.h>
#include <Widgets/2D/List/Content/ISizeContainer.h>

class ItemLayouter : public Candera::Layouter
{
   public:
      ItemLayouter(ISizeContainer& sizeContainer);

      virtual void Dispose();

   protected:
      Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);

      void OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea);

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override
      {
         return OnMeasure(*(node.ToNode2D()), clientArea);
      }

      virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override
      {
         OnArrange(*(node.ToNode2D()), clientArea);
      }

#endif

      virtual Candera::Layouter* Clone() const;

   private:
      ISizeContainer& _sizeContainer;
};


#endif
