/* ***************************************************************************************
* FILE:          ItemLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloningStrategy.h"

#if defined SESA_ARABIC_LAYOUT_FIX
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include "Candera/EngineBase/Layout/ArabicLayouterPatch.h"
#else
#include "Candera/Engine2D/Layout/ArabicLayouterPatch.h"
#endif
#endif

#include "ItemLayouter.h"
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/LayoutTypes.h>
#else
#include <Candera/Engine2D/Layout/LayoutTypes.h>
#endif

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ItemLayouter.cpp.trc.h"
#endif

using namespace Candera;


ItemLayouter::ItemLayouter(ISizeContainer& sizeContainer) :
   _sizeContainer(sizeContainer)
{
}


void ItemLayouter::Dispose()
{
}


Candera::Vector2 ItemLayouter::OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea)
{
   Float width = 0.0F;
   Float height = 0.0F;

   Candera::Vector2 childArea(clientArea);

   Candera::Node2D* child = node.GetFirstChild();
   while (child != 0)
   {
      Candera::Vector2 preferredChildSize(_sizeContainer.MeasureClientSize(child));

      if (width < preferredChildSize.GetX())
      {
         width = preferredChildSize.GetX();
      }
      if (height < preferredChildSize.GetY())
      {
         height = preferredChildSize.GetY();
      }

      child = child->GetNextSibling();
   }

   return Candera::Vector2(width, height);
}


#if defined SESA_ARABIC_LAYOUT_FIX
void ItemLayouter::OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   if (Candera::ArabicLayouterPatch::IsSceneEnabled(node))
   {
      ControlTemplateCloningStrategy::SetLayoutArea(node, clientArea);
      const Candera::Float clientWidth = clientArea.GetWidth();
      const Candera::Float clientHeight = clientArea.GetHeight();
      Candera::Float actualWidth = 0.0F;
      Candera::Float actualHeight = 0.0F;
      Candera::Node2D* child = node.GetFirstChild();
      while (child != 0)
      {
         Candera::Layouter* childLayouter = child->GetLayouter();
         if (childLayouter != 0)
         {
            Candera::Rectangle childArea(0.0F, 0.0F, clientWidth, clientHeight);
            childLayouter->Arrange(*child, childArea);
            const Candera::Margin& margin = Layouter::GetMargin(*child);
            Candera::Vector2 topLeftMargin(static_cast<Candera::Float>((GetLanguageSensitiveDirection(*child) == LayoutAlignment::LayoutDirection::RightToLeftDirection) ? margin.GetRight() : margin.GetLeft()), margin.GetBottom());
            Candera::Vector2 childSize = GetArrangeActualSize() + child->GetPosition() - topLeftMargin;
            if (actualWidth < childSize.GetX())
            {
               actualWidth = childSize.GetX();
            }
            if (actualHeight < childSize.GetY())
            {
               actualHeight = childSize.GetY();
            }
         }

         child = child->GetNextSibling();
      }
      SetArrangeActualSize(Vector2(actualWidth, actualHeight));
   }
   else
   {
      ControlTemplateCloningStrategy::SetLayoutArea(node, clientArea);
      const Float clientWidth = clientArea.GetWidth();
      const Float clientHeight = clientArea.GetHeight();

      Candera::Node2D* child = node.GetFirstChild();
      while (child != 0)
      {
         Layouter* childLayouter = child->GetLayouter();
         if (childLayouter != 0)
         {
            Candera::Rectangle childArea(0.0F, 0.0F, clientWidth, clientHeight);
            AlignRectangle(childArea, childArea, *child);
            childLayouter->Arrange(*child, childArea);
         }

         child = child->GetNextSibling();
      }

      node.SetPosition(clientArea.GetPosition());
   }
}


#else
void ItemLayouter::OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   ControlTemplateCloningStrategy::SetLayoutArea(node, clientArea);
   const Float clientWidth = clientArea.GetWidth();
   const Float clientHeight = clientArea.GetHeight();

   Candera::Node2D* child = node.GetFirstChild();
   while (child != 0)
   {
      Layouter* childLayouter = child->GetLayouter();
      if (childLayouter != 0)
      {
         Candera::Rectangle childArea(0.0F, 0.0F, clientWidth, clientHeight);
         AlignRectangle(childArea, childArea, *child);
         childLayouter->Arrange(*child, childArea);
      }

      child = child->GetNextSibling();
   }

   node.SetPosition(clientArea.GetPosition());
}


#endif


Candera::Layouter* ItemLayouter::Clone() const
{
   ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "An ItemLayouter should never be cloned"));

   // An ItemLayouter should never be cloned
   FEATSTD_DEBUG_ASSERT(true);
   return 0;
}
