/* ***************************************************************************************
* FILE:          FixedSizeCloneCachingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FixedSizeCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(FixedSizeCloneCachingStrategy_H)
#define FixedSizeCloneCachingStrategy_H

#include "ControlTemplateCloningStrategy.h"
#include <Widgets/2D/List/generated/ListWidget2DBase.h>

/**
 * The FixedSizeCloneCachingStrategy will cache ControlTemplateInstance instead of disposing them.
  * By deriving from FixedSizeCloneCachingStrategy and implementing GetMaxNumberOfInstancesPerTemplate the cache size can be limited.
 */
class FixedSizeCloneCachingStrategy : public CloneCachingStrategy
{
   public:
      virtual ControlTemplateInstancePtr Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations) override;
      virtual void ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index) override;
      virtual bool ProcessBeforeDisposed(ControlTemplateInstance* instance) override;
      virtual void ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex) override;
      virtual void Finalize() override;

   protected:
      /**
       * Returns the cache size limit.
       */
      virtual FeatStd::UInt32 GetMaxNumberOfInstancesPerTemplate();

   private:
      typedef std::stack<ControlTemplateInstancePtr> ControlTemplateInstanceTemplateCache;
      typedef std::map<const void*, ControlTemplateInstanceTemplateCache> ControlTemplateInstanceCache;
      ControlTemplateInstanceCache _cache;
};


#endif
