/* ***************************************************************************************
* FILE:          FixedSizeCloneCachingStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FixedSizeCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ControlTemplate.h"
#include "FixedSizeCloneCachingStrategy.h"
#include <Widgets/2D/ControlTemplate/CloneEvents.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FixedSizeCloneCachingStrategy.cpp.trc.h"
#endif
#include "CloneCachingStrategyHelper.h"


ControlTemplateInstancePtr FixedSizeCloneCachingStrategy::Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations)
{
   ControlTemplateInstancePtr controlTemplateInstance(0);

   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "FixedSizeCloneCachingStrategy::Retrieve owner=%p, template=%s", owner, templateNode.GetName()));

   ControlTemplateInstanceCache::iterator it = _cache.find(&templateNode);
   if (it != _cache.end())
   {
      while ((it->second.size() > 0) && (it->second.top().PointsToNull()))
      {
         it->second.pop();
      }
      if (it->second.size() > 0)
      {
         controlTemplateInstance = it->second.top();
         it->second.pop();

         ReuseInstanceEvent reuseInstanceEvent(controlTemplateInstance, templateNode, source, owner);

         CloneCachingStrategyHelper().UpdateControlTemplateInstance(controlTemplateInstance, reuseInstanceEvent, templateNode, source, owner, templateAnimations);
      }
   }

   return controlTemplateInstance;
}


void FixedSizeCloneCachingStrategy::ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index)
{
   // do nothing
}


bool FixedSizeCloneCachingStrategy::ProcessBeforeDisposed(ControlTemplateInstance* instance)
{
   bool dispose(true);

   if ((0 != instance) && (0 != instance->GetItemRootNode()))
   {
      Candera::Node2D* itemRootNode(instance->GetItemRootNode());
      const void* templateNode = instance->GetTemplateNode();
      ControlTemplateInstanceTemplateCache& templateCache = _cache[templateNode];
      if (templateCache.size() < GetMaxNumberOfInstancesPerTemplate())
      {
         templateCache.push(ControlTemplateInstancePtr(instance));
         dispose = false;
      }
   }

   return dispose;
}


void FixedSizeCloneCachingStrategy::ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex)
{
}


void FixedSizeCloneCachingStrategy::Finalize()
{
   _cache.clear();
}


FeatStd::UInt32 FixedSizeCloneCachingStrategy::GetMaxNumberOfInstancesPerTemplate()
{
   // by default there is no limitation in the number of cached instances
   return FeatStd::UInt32(-1);
}
