/* ***************************************************************************************
* FILE:          ControlTemplateWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/ControlTemplate/ControlTemplate.h"
#include "ControlTemplateWidget2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ControlTemplateWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ControlTemplateWidget2D)


ControlTemplateWidget2D::ControlTemplateWidget2D()
{
   SetEnabledBindingIndex(-1);
   SetNameBindingIndex(-1);
   SetTextBindingIndex(-1);
   SetSelectedBindingIndex(-1);
   SetItemsBindingIndex(-1);
   SetUserDataBindingIndex(-1);
}


void ControlTemplateWidget2D::OnChanged(Candera::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   if (0 != GetNode())
   {
      switch (propertyId)
      {
         case ControlTemplateWidget2D::EnabledBindingIndexPropertyId:
            ControlTemplate::SetEnabledBindingIndex(*GetNode(), Candera::UInt32(GetEnabledBindingIndex()));
            break;
         case ControlTemplateWidget2D::NameBindingIndexPropertyId:
            ControlTemplate::SetNameBindingIndex(*GetNode(), Candera::UInt32(GetNameBindingIndex()));
            break;
         case ControlTemplateWidget2D::TextBindingIndexPropertyId:
            ControlTemplate::SetTextBindingIndex(*GetNode(), Candera::UInt32(GetTextBindingIndex()));
            break;
         case ControlTemplateWidget2D::SelectedBindingIndexPropertyId:
            ControlTemplate::SetSelectedBindingIndex(*GetNode(), Candera::UInt32(GetSelectedBindingIndex()));
            break;
         case ControlTemplateWidget2D::ItemsBindingIndexPropertyId:
            ControlTemplate::SetItemsBindingIndex(*GetNode(), Candera::UInt32(GetItemsBindingIndex()));
            break;
         case ControlTemplateWidget2D::UserDataBindingIndexPropertyId:
            ControlTemplate::SetUserDataBindingIndex(*GetNode(), Candera::UInt32(GetUserDataBindingIndex()));
            break;
         default:
            break;
      }
   }
}


/*
namespace Internal {
    template<> bool SourceItemHelper<bool>::Get(const tSharedPtrDataItem& source, Candera::Int32 sourceIndex) { return 0 != ControlTemplateBinding::GetSourceItemAsInteger(source, sourceIndex); }
    template<> Candera::Int32 SourceItemHelper<Candera::Int32>::Get(const tSharedPtrDataItem& source, Candera::Int32 sourceIndex) { return ControlTemplateBinding::GetSourceItemAsInteger(source, sourceIndex); }
    template<> Candera::String SourceItemHelper<Candera::String>::Get(const tSharedPtrDataItem& source, Candera::Int32 sourceIndex) { return ControlTemplateBinding::GetSourceItemAsString(source, sourceIndex); }
}


*/
