/* ***************************************************************************************
* FILE:          ControlTemplateInstanceContainer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateInstanceContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CONTROL_TEMPLATE_INSTANCE_CONTAINER_H
#define CONTROL_TEMPLATE_INSTANCE_CONTAINER_H

#include <CanderaWidget/Widget2D/Widget2D.h>
#include "ControlTemplateInstance.h"
#include <Widgets/2D/List/generated/ListWidget2DBase.h>
#include <Widgets/2D/Common/OwnerInfoRetriever.h>
#include <Widgets/2D/List/Content/ITemplateRetriever.h>

class ControlTemplateCloningStrategy;
class ControlTemplateInstanceContainer
{
   public:
      ControlTemplateInstanceContainer(const OwnerInfoRetriever& ownerInfoRetriever);

      ~ControlTemplateInstanceContainer();

      void Init(Candera::Node2D* itemsGroup)
      {
         DisposeContent();
         _itemsGroup = itemsGroup;
      }

      Courier::Vector<ControlTemplateInstancePtr>& GetInstances()
      {
         return _controlTemplateInstances;
      }

      void SetCloningStrategy(ControlTemplateCloningStrategy* cloningStrategy)
      {
         _cloningStrategy = cloningStrategy;
      }

      void DisposeContent();
      void ResetClippingRectangle();
      void Update(bool invalidateCachedLayout = false);
      Candera::Node2D* AddControlTemplateClone(const ITemplateRetriever& templateRetriever, const tSharedPtrListDataItem& source, FeatStd::UInt32 index);
      bool OnMessage(const Courier::Message& msg);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ControlTemplateInstanceContainer);
      friend class ControlTemplateCloneTraverser2D;
      friend class ControlTemplateDisposeTraverser;
      friend class ControlTemplate;

//      Courier::Vector<ControlTemplateInstancePtr> _controlTemplateInstances; // fr83hi: SESA TODO for LINT
      const OwnerInfoRetriever& _ownerInfoRetriever;
      Candera::Node2D* _itemsGroup;
      ControlTemplateCloningStrategy* _cloningStrategy;

   public:
      Courier::Vector<ControlTemplateInstancePtr> _controlTemplateInstances;  // fr83hi: SESA TODO for LINT // Warning 1536: prio1: Exposing low access member when this member is private
   private:
};


#endif
