/* ***************************************************************************************
* FILE:          ControlTemplateData.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateData is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ControlTemplateData_H)
#define ControlTemplateData_H

#include "TEnumerator.h"
#include <CanderaWidget/WidgetBase/WidgetBase.h>
#include <Candera/EngineBase/Common/ApplicationData.h>
#include "ControlTemplateInstance.h"
#include "DataItem.h"


typedef TEnumerator<Candera::WidgetBase*> WidgetBaseEnumerator;

/**
 * The ControlTemplateData is the central storage of the control template cloning mechanism.
 * It allows to store the set of associated widgets, the data context as source for any data binding.
 * NOTE: The ControlTemplateData is used internally and is not intended to be used directly.
 * Use the ControlTemplate instead to access the relevant data.
 * One ControlTemplateData can be set per node.
 */
class ControlTemplateData
{
   public:
      ControlTemplateData();

      /**
       * Sets a ControlTemplateInstance for this ControlTemplateData.
       */
      void SetControlTemplateInstance(ControlTemplateInstance* value);

      /**
       * Returns a ControlTemplateInstance of this ControlTemplateData if set.
       * NOTE: ControlTemplateData instances without a ControlTemplateInstance are possible.
       */
      ControlTemplateInstance* GetControlTemplateInstance();

      /**
       * Adds an associated widget to this ControlTemplateData.
       */
      void AddAssociatedWidget(Candera::WidgetBase* widget);

      /**
       * Returns an enumeration of all widgets that are associated with this ControlTemplateData.
       */
      WidgetBaseEnumerator EnumerateAssociatedWidgets() const;

      /**
       * Sets a the data context of this ControlTemplateData (which will be used for data binding).
       */
      void SetDataContext(const tSharedPtrIDataItem& value);

      /**
       * Returns the data context of this ControlTemplateData (which will be used for data binding).
       */
      const tSharedPtrIDataItem& GetDataContext() const;

      /**
       * Marks this ControlTemplateData as the ControlTemplateData of a control template node that is used for cloning only.
       */
      void SetTemplateNode(bool isTemplateNode);

      /**
       * Returns true if this ControlTemplateData is marked as a control template node that is used for cloning only.
       * NOTE: control template nodes within a control template are not cloned because their use is only to be a template for further cloning.
       * In conclusion also references to these nodes and referenced widgets within these template nodes are not replaced with cloned versions.
       */
      bool IsTemplateNode() const;

   private:
      Courier::Vector<Candera::WidgetBase*> _associatedWidgets;
      ControlTemplateInstance* _controlTemplateInstance;
      tSharedPtrIDataItem _dataContext;
      bool _isTemplateNode;
};


#endif
