/* ***************************************************************************************
* FILE:          ControlTemplateCloneTraverser2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateCloneTraverser2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplate.h"
#include "ControlTemplateWidget2D.h"
#include "Widgets/2D/Slider/SliderWidget2D.h"
#include "Widgets/2D/Slider/ListWidget2DSliderWidget2D.h"
#include "CanderaPlatform/Device/Common/Effects/GlMaskEffect.h"
#include "Candera/System/Rtti/Rtti.h"

#include "ControlTemplateCloneTraverser2D.h"
#include <Candera/System/Rtti/Rtti.h>

#include "hmi_trace_if.h"
#include "Widgets/widget_etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ControlTemplateCloneTraverser2D.cpp.trc.h"
#endif


using namespace Courier;

ControlTemplateCloneTraverser2D::ControlTemplateCloneTraverser2D(ControlTemplateInstance& controlTemplateInstance, const tSharedPtrIDataItem& source, DefaultControlTemplateMap& controlTemplateMap) :
   _controlTemplateInstance(controlTemplateInstance),
   _controlTemplateMap(controlTemplateMap),
   _source(source)
{
}


TraverserBase::TraverserAction ControlTemplateCloneTraverser2D::OnClone(const Candera::Node2D& node, Candera::Node2D& nodeClone)
{
   ControlTemplate::ResetControlTemplateData(nodeClone, false);

   DefaultControlTemplateMap::NodeCloneMapping nodeMapping = { &node, &nodeClone };
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnClone node = %p, nodeClone = %p", &node, &nodeClone));
   if (!_controlTemplateMap._nodeCloneMap.Add(nodeMapping))
   {
      return TraverserBase::StopTraversing;
   }

   const Candera::RenderNode* renderNode = Candera::Dynamic_Cast<const Candera::RenderNode*>(&node);
   const Candera::RenderNode* renderNodeClone = Candera::Dynamic_Cast<const Candera::RenderNode*>(&nodeClone);
   if (0 != renderNode && 0 != renderNodeClone)
   {
      UInt8 effectCnt = 0;
      while (0 != renderNode->GetEffect(effectCnt))
      {
         DefaultControlTemplateMap::EffectCloneMapping effectMapping = { renderNode->GetEffect(effectCnt), renderNodeClone->GetEffect(effectCnt) };
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnClone effect = %p, effectClone = %p", effectMapping._effect, effectMapping._effectClone));
         if (!_controlTemplateMap._effectCloneMap.Add(effectMapping))
         {
            return TraverserBase::StopTraversing;
         }
         effectCnt++;
      }
   }

   WidgetBaseEnumerator associatedWidgets = ControlTemplate::EnumerateAssociatedWidgets(*static_cast<Courier::ViewScene*>(_controlTemplateInstance.GetOwner()->GetParentView()), node);
   while (associatedWidgets.MoveNext())
   {
      ControlTemplateWidget2D* controlTemplateWidget2D = Candera::Dynamic_Cast<ControlTemplateWidget2D*>(associatedWidgets.Current());
      if (0 == controlTemplateWidget2D)
      {
         Candera::WidgetBase* currentWidget = associatedWidgets.Current();
         if ((0 != currentWidget) && !currentWidget->PrepareForCloning())
         {
            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnClone nodeClone=%p(%50s), widget=%p(%s) widget not prepared for cloning!",
                                &nodeClone, nodeClone.GetName(), currentWidget, currentWidget->GetLegacyName()));
            return TraverserBase::ProceedTraversing;
         }

         FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
         DefaultControlTemplateMap::WidgetCloneMapping widgetMapping = { &nodeClone, associatedWidgets.Current(), 0 };
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnClone nodeClone = %p, widget = %p, widgetClone = %p", &nodeClone, widgetMapping._widget, widgetMapping._widgetClone));
         if (!_controlTemplateMap._widgetCloneMap.Add(widgetMapping))
         {
            return TraverserBase::StopTraversing;
         }
      }
   }
   return TraverserBase::ProceedTraversing;
}


void ControlTemplateCloneTraverser2D::OnTraverseEnd(TraverserAction exitAction)
{
   if ((exitAction == ProceedTraversing) && (0 != GetRootClone()))
   {
      Candera::Node2D* rootNode = _controlTemplateInstance.GetItemRootNode();
      if (0 != rootNode)
      {
         static_cast<void>(rootNode->AddChild(GetRootClone()));
      }
      else
      {
         rootNode = GetRootClone();
      }

      ControlTemplate::SetDataContext(*rootNode, _source);
      if (!_source.PointsToNull())
      {
         bool updated(_source->updateDataBindings(true));
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnTraverseEnd updated = %d", updated));
      }

      ControlTemplate::SetControlTemplateInstance(*rootNode, &_controlTemplateInstance);

      CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1502, "Object used for its comparison function.")
      DefaultControlTemplateMap::NodeCloneMappingComparator nodeComparator;
      CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1502, "Object used for its comparison function.")
      DefaultControlTemplateMap::EffectCloneMappingComparator effectComparator;
      CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1502, "Object used for its comparison function.")
      DefaultControlTemplateMap::WidgetCloneMappingComparator widgetComparator;
      _controlTemplateMap._nodeCloneMap.Sort(nodeComparator);
      _controlTemplateMap._effectCloneMap.Sort(effectComparator);
      for (Int i = 0; i < (int) _controlTemplateMap._widgetCloneMap.Size(); ++i)
      {
         DefaultControlTemplateMap::WidgetCloneMapping& cloneMapping = _controlTemplateMap._widgetCloneMap[i];
         if (0 != cloneMapping._widget)
         {
            SliderWidget2D* sliderWidget2D = Candera::Dynamic_Cast<SliderWidget2D*>(cloneMapping._widget);
            Candera::MetaInfo::WidgetMetaInfo* metaInfo = cloneMapping._widget->GetMetaInfo();
            if (0 != sliderWidget2D)
            {
               cloneMapping._widgetClone = CANDERA_NEW(ListWidget2DSliderWidget2D)();
            }
            else if (0 != metaInfo)
            {
               cloneMapping._widgetClone = Candera::Dynamic_Cast<Candera::Widget2D*>(metaInfo->Create());
            }
            if (0 != cloneMapping._widgetClone)
            {
               ControlTemplate::AddAssociatedWidget(*cloneMapping._nodeClone, cloneMapping._widgetClone);
            }
            else
            {
               Clear();
               ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnTraverseEnd cleared nodeClone = %p, widget = %p, widgetClone = %p", cloneMapping._nodeClone, cloneMapping._widget, cloneMapping._widgetClone));
               return;
            }
            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnTraverseEnd nodeClone = %p, widget = %p, widgetClone = %p", cloneMapping._nodeClone, cloneMapping._widget, cloneMapping._widgetClone));
         }
      }

      for (Int i = 0; i < (int) _controlTemplateMap._nodeCloneMap.Size(); ++i)
      {
         DefaultControlTemplateMap::NodeCloneMapping& nodeMapping(_controlTemplateMap._nodeCloneMap[i]);
         const Candera::RenderNode* renderNodeClone(Candera::Dynamic_Cast<const Candera::RenderNode*>(nodeMapping._nodeClone));
         if (0 != renderNodeClone)
         {
            Candera::Effect2D* effectClone(renderNodeClone->GetEffect(0));
            if (0 != effectClone)
            {
               for (UInt8 e = 0; e < effectClone->GetInPlaceEffect2DCount(); ++e)
               {
                  Candera::GlMaskEffect* maskEffectClone(Candera::Dynamic_Cast<Candera::GlMaskEffect*>(effectClone->GetInPlaceEffect2D(e)));
                  if (0 != maskEffectClone)
                  {
                     Candera::Node2D* maskNodeClone(_controlTemplateMap.ResolveNodeClone(maskEffectClone->MaskNode()));
                     maskEffectClone->MaskNode() = maskNodeClone;
                  }
               }
            }
         }
      }

      for (Int i = 0; i < (int) _controlTemplateMap._widgetCloneMap.Size(); ++i)
      {
         _controlTemplateInstance.AddWidget(_controlTemplateMap._widgetCloneMap[i]._widgetClone);
      }
      _controlTemplateMap._widgetCloneMap.Sort(widgetComparator);
      if (_controlTemplateMap.ClonePropertiesInternal())
      {
         _controlTemplateInstance.Init();
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnTraverseEnd cloned"));
      }
      else
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateCloneTraverser2D::OnTraverseEnd not cloned"));
         _controlTemplateInstance.Clear();
      }
   }
}


void ControlTemplateCloneTraverser2D::OnClear()
{
   for (Int i = 0; i < (int) _controlTemplateMap._widgetCloneMap.Size(); ++i)
   {
      DefaultControlTemplateMap::WidgetCloneMapping& cloneMapping = _controlTemplateMap._widgetCloneMap[i];
      if (0 != cloneMapping._widgetClone)
      {
         cloneMapping._widgetClone->Finalize();
      }
   }
   for (Int i = 0; i < (int) _controlTemplateMap._widgetCloneMap.Size(); ++i)
   {
      DefaultControlTemplateMap::WidgetCloneMapping& cloneMapping = _controlTemplateMap._widgetCloneMap[i];
      if (0 != cloneMapping._widgetClone)
      {
         cloneMapping._widgetClone->Dispose();
         cloneMapping._widgetClone = 0;
      }
   }
   _controlTemplateMap._widgetCloneMap.Clear();
}
