/* ***************************************************************************************
* FILE:          ControlTemplateBinding.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateBinding is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ControlTemplate.h"
#include "FeatStd/Diagnostics/Log.h"


#include "ControlTemplateBinding.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ControlTemplateBinding.cpp.trc.h"
#endif


tSharedPtrIDataItem ControlTemplateBinding::GetDataContext(const Candera::Widget2D& widget)
{
   return (0 == widget.GetNode()) ? tSharedPtrIDataItem() : ControlTemplate::GetDataContext(*widget.GetNode());
}


Candera::String ControlTemplateBinding::GetErrorString()
{
   return Candera::String("error ###### error ###### error");
}


Candera::String ControlTemplateBinding::GetSourceItemAsString(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex)
{
   FEATSTD_DEBUG_ASSERT(!source.PointsToNull());
   if (!source.PointsToNull())
   {
      if (source->isVector())
      {
         Candera::Int32 size = Candera::Int32((*source).size());
         if ((sourceIndex >= 0) && (sourceIndex < size))
         {
            return *(*source)[Candera::UInt32(sourceIndex)];
         }
         else
         {
            ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is a vector but uses out of range index; sourceIndex = %d, size = %d)!", sourceIndex, size));
         }
      }
      else if (sourceIndex == 0)
      {
         return *source;
      }
      else
      {
         ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is not a vector but uses index larger than 0; source index = %d)!", sourceIndex));
      }
   }
   else
   {
      ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString could not retreive string due to missing data item!"));
   }
   return GetErrorString();
}


Candera::Int32 ControlTemplateBinding::GetSourceItemAsInteger(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex)
{
   FEATSTD_DEBUG_ASSERT(!source.PointsToNull());
   if (!source.PointsToNull())
   {
      if (source->isVector())
      {
         Candera::Int32 size = Candera::Int32((*source).size());

         if ((sourceIndex >= 0) && (sourceIndex < size))
         {
            return static_cast<Candera::Int32>(*(*source)[Candera::UInt32(sourceIndex)]);
         }
         else
         {
            ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is a vector but uses out of range index; sourceIndex = %d, size = %d)!", sourceIndex, size));
         }
      }
      else
      {
         if (sourceIndex == 0)
         {
            return static_cast<Candera::Int32>(*source);
         }
         else
         {
            ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is not a vector but uses index larger than 0; source index = %d)!", sourceIndex));
         }
      }
   }
   return 0;
}


void ControlTemplateBinding::SetSourceItemFromInteger(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex, Candera::Int32 value)
{
   FEATSTD_DEBUG_ASSERT(!source.PointsToNull());
   if (!source.PointsToNull())
   {
      if (source->isVector())
      {
         Candera::Int32 size = Candera::Int32((*source).size());
         if ((sourceIndex >= 0) && (sourceIndex < size))
         {
            *(*source)[Candera::UInt32(sourceIndex)] = value;
         }
         else
         {
            ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is a vector but uses out of range index; sourceIndex = %d, size = %d)!", sourceIndex, size));
         }
      }
      else
      {
         if (sourceIndex == 0)
         {
            source.GetSharedInstance() = value;
         }
         else
         {
            ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "ControlTemplateBinding: GetSourceItemAsString received misconfigured data item from data model (data is item is not a vector but uses index larger than 0; source index = %d)!", sourceIndex));
         }
      }
   }
}


#define CdaDynamicPropertyInstance_BindingIndex(propName)    \
    (Candera::DynamicProperties::Instance<DynamicPropertiesSpec::propName##BindingIndexPropSpec>::Property())

#define ControlTemplateImplementation(bindingName) \
\
void ControlTemplate::FEATSTD_CONCAT3(Set,bindingName,BindingIndex)(Candera::Node2D& node, const FeatStd::UInt32& value) \
{ \
    static_cast<void>(node.SetValue(CdaDynamicPropertyInstance_BindingIndex(bindingName), value)); \
} \
\
bool ControlTemplate::FEATSTD_CONCAT3(Is,bindingName,BindingIndexSet)(const Candera::Node2D& node) \
{ \
    return node.IsValueSet(CdaDynamicPropertyInstance_BindingIndex(bindingName)); \
} \
\
FeatStd::Int32 ControlTemplate::FEATSTD_CONCAT3(Get,bindingName,BindingIndex)(const Candera::Node2D& node) \
{ \
    return node.GetValue(CdaDynamicPropertyInstance_BindingIndex(bindingName)); \
}


#define ControlTemplateBindingImplementation(bindingName) \
ControlTemplateImplementation(bindingName) \
\
bool ControlTemplateBinding::FEATSTD_CONCAT3(Is,bindingName,Bindable)(const Candera::Widget2D& widget) \
{ \
    if (GetDataContext(widget).PointsToNull()) { return false; } \
    Candera::Node2D* node = widget.GetNode(); \
    if (0 == node) { return false; } \
    if (ControlTemplate::IsTemplateNode(*node)) { return false; } \
    return ControlTemplate::FEATSTD_CONCAT3(Is,bindingName,BindingIndexSet)(*node); \
} \
\
Candera::Int32 ControlTemplateBinding::FEATSTD_CONCAT3(Get,bindingName,BindingIndex)(const Candera::Widget2D& widget) \
{ \
    FEATSTD_DEBUG_ASSERT(0 != widget.GetNode()); \
    if (0 != widget.GetNode()) { \
        return ControlTemplate::FEATSTD_CONCAT3(Get,bindingName,BindingIndex)(*widget.GetNode()); \
            } \
    return -1; \
}


#define ControlTemplateBindingImplementation2(typeName, bindingName) \
ControlTemplateBindingImplementation(bindingName) \
\
typeName ControlTemplateBinding::FEATSTD_CONCAT3(Get,bindingName,Value)(const Candera::Widget2D& widget) \
{ \
    return GetSourceItem<typeName>(GetDataContext(widget), FEATSTD_CONCAT3(Get,bindingName,BindingIndex)(widget)); \
}


ControlTemplateBindingImplementation2(bool, Enabled)
ControlTemplateBindingImplementation2(Candera::String, Name)
ControlTemplateBindingImplementation2(Candera::String, Text)
ControlTemplateBindingImplementation2(Candera::Int32, Selected)
ControlTemplateBindingImplementation2(Candera::Int32, UserData)

ControlTemplateBindingImplementation(Items)

void ControlTemplateBinding::SetSelectedValue(const Candera::Widget2D& widget, Candera::Int32 value)
{
   SetSourceItemFromInteger(GetDataContext(widget), GetSelectedBindingIndex(widget), value);
}
