/* ***************************************************************************************
* FILE:          CloneProperties.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CloneProperties is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(CloneProperties_H)
#define CloneProperties_H

#include "ControlTemplateInstance.h"
#include <Courier/Version.h>
#include <CanderaWidget/Widget2D/Widget2D.h>
#include <Widgets/2D/RichTextBase/generated/RichTextBaseWidget2DBase.h>
#include <Widgets/2D/TextArea/TextAreaWidget2D.h>
#include <Widgets/2D/ScrollableText/generated/ScrollableTextWidget2DBase.h>

namespace PropertiesClonners {
void CloneProperties(const Candera::Widget2D& widget, Candera::Widget2D& widgetClone, ControlTemplateInstance& controlTemplateInstance);
void CloneProperties(const Candera::Animation::AnimationPlayer& animationPlayer, Candera::Animation::AnimationPlayer& animationPlayerClone);
void CloneProperties(const Candera::Animation::AnimationController& animationController, Candera::Animation::AnimationController& animationControllerClone);

template <typename T> bool CloneWidgetCloneProperties(Candera::WidgetBase* widgetBase, Candera::WidgetBase* widgetBaseClone, ControlTemplateInstance& controlTemplateInstance)
{
   T* widget = Candera::Dynamic_Cast<T*>(widgetBase);
   T* tClone = Candera::Dynamic_Cast<T*>(widgetBaseClone);
   if ((0 != widget) && (0 != tClone))
   {
      CloneProperties(*widget, *tClone, controlTemplateInstance);
      return true;
   }
   return false;
}


}

#endif
