/* ***************************************************************************************
* FILE:          CloneNodeEvent.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateCloningStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CLONE_EVENTS_H
#define CLONE_EVENTS_H

#include "ControlTemplateInstance.h"
#include <map>
#include <stack>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyHost.h>
#include <FeatStd/Util/ConvenienceMacros.h>
#include "Widgets/2D/Common/EventHub.h"
#include "ControlTemplateInstanceOwner.h"
#include "DefaultControlTemplateMap.h"
#include <Candera/Engine2D/Core/TreeTraverser2D.h>
#include <Widgets/2D/List/generated/ListWidget2DBase.h>

/**
 * The CloneNodeEvent is sent by the ControlTemplateCloningStrategy when a node was cloned.
 */
class CloneNodeEvent : public EventHub::Event
{
   public:
      CloneNodeEvent(const ControlTemplateInstancePtr& instance, const Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, const BaseWidget2D* owner) :
         _instance(instance),
         _templateNode(templateNode),
         _source(source),
         _owner(owner)
      {
      }

      virtual ~CloneNodeEvent()
      {
         _owner = 0;
      }

      const ControlTemplateInstancePtr& GetInstance() const
      {
         return _instance;
      }

      const Candera::Node2D& GetTemplateNode() const
      {
         return _templateNode;
      }

      const tSharedPtrIDataItem& GetSource() const
      {
         return _source;
      }

      const BaseWidget2D* GetOwner() const
      {
         return _owner;
      }

   protected:

      const ControlTemplateInstancePtr& _instance;
      const Candera::Node2D& _templateNode;
      const tSharedPtrIDataItem& _source;
      const BaseWidget2D* _owner;
};


class CachedInstanceEvent : public CloneNodeEvent
{
   public:
      CachedInstanceEvent(const ControlTemplateInstancePtr& instance, const Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, const BaseWidget2D* owner) :
         CloneNodeEvent(instance, templateNode, source, owner)
      {
      }
};


// ReuseInstanceEvent kept for compatibility reasons - should be replaced with CachedInstanceEvent
class ReuseInstanceEvent : public CachedInstanceEvent
{
   public:
      ReuseInstanceEvent(const ControlTemplateInstancePtr& instance, const Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, const BaseWidget2D* owner) :
         CachedInstanceEvent(instance, templateNode, source, owner)
      {
      }
};


#endif
