/* ***************************************************************************************
* FILE:          BaseClonedItemCachingBehavior.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BaseClonedItemCachingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "BaseClonedItemCachingBehavior.h"
#include <Widgets/2D/List/generated/ListMessages.h>


BaseClonedItemCachingBehavior::BaseClonedItemCachingBehavior(OwnerInfoRetriever& ownerRetriever, CloneCachingStrategy& mainCachingStrategy) :
   _ownerRetriever(ownerRetriever),
   _cachingStrategy(),
   _cloningStrategy(_cachingStrategy)
{
   _cachingStrategy.SetOther(&mainCachingStrategy);
}


ControlTemplateCloningStrategy& BaseClonedItemCachingBehavior::GetCloningStrategy()
{
   return _cloningStrategy;
}


bool BaseClonedItemCachingBehavior::OnMessage(const Courier::Message& msg)
{
   if (msg.GetId() == ListCacheReqMsg::ID)
   {
      const ListCacheReqMsg* cacheReqMsg(Courier::message_cast<const ListCacheReqMsg*>(&msg));
      if (0 != cacheReqMsg)
      {
         if (cacheReqMsg->GetListId() == _ownerRetriever.GetOwnerId())
         {
            if (cacheReqMsg->GetCache())
            {
               _cachingStrategy.Retain(cacheReqMsg->GetIndex());
            }
            else
            {
               _cachingStrategy.Release(cacheReqMsg->GetIndex());
            }
         }
      }
   }

   return _cachingStrategy.OnMessage(msg);;
}


void BaseClonedItemCachingBehavior::Update()
{
   _cachingStrategy.Update();
}
