/* ***************************************************************************************
* FILE:          PagesInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PagesInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef PageInfo_H
#define PageInfo_H

#include <FeatStd/Platform/Types.h>

class PagesInfo
{
   public:
      virtual ~PagesInfo() {}

      /**
       * Retrieves the start index of the given page. The page index is zero based relative to the current page.
       * For example, the previous page has index -1, while the next page has index 1.
       *
       * If data is not available for the requested page, the start index is calculated based on the number of
       * items in the current page and the last available start index
       *
       * returns true if data was available for the requested page index; false otherwise
       */
      virtual bool RetrieveStartIndexOfPage(const FeatStd::Int32 pageIndex, FeatStd::Int32& startIndex) const = 0;

      /**
       * Returns the starting index of the last available page
       */
      virtual FeatStd::Int32 GetStartIndexOfLastPage() const = 0;
};


#endif
