/* ***************************************************************************************
* FILE:          ListItemAnimationDynamicPropertyHost.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListItemAnimationDynamicPropertyHost is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListItemAnimationDynamicPropertyHost_h)
#define ListItemAnimationDynamicPropertyHost_h


#include "Candera/EngineBase/DynamicProperties/DynamicPropertyHost.h"
#include "Candera/EngineBase/Animation/AnimationPlayer.h"

#include <Widgets/2D/List/generated/ListEnums.h>

class ListItemAnimationDynamicPropertyHost : public Candera::DynamicProperties::DynamicPropertyHost
{
   public:
      typedef ListItemAnimationType ListItemAnimationTypeType;

      static void SetListItemAnimationType(const Candera::Animation::AnimationPlayer::SharedPointer& animation, ListItemAnimationTypeType val);

      static bool IsListItemAnimationOfType(const Candera::Animation::AnimationPlayer::SharedPointer& animation, ListItemAnimationTypeType val);

      static ListItemAnimationTypeType GetListItemAnimationType(const Candera::Animation::AnimationPlayer::SharedPointer& animation);

      static const Candera::DynamicProperties::DynamicPropertyHost* ParentProvider(const Candera::DynamicProperties::DynamicPropertyHost* host)
      {
         FEATSTD_UNUSED(host);
         return 0;
      }

   private:

      FEATSTD_MAKE_CLASS_STATIC(ListItemAnimationDynamicPropertyHost);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ListItemAnimationDynamicPropertyHost);

      static const ListItemAnimationTypeType& GetListItemAnimationTypeDefault();

      /**
      * Dynamic property definitions.
      */
      CdaDynamicProperties(ListItemAnimationDynamicPropertyHost, Candera::DynamicProperties::DynamicPropertyHost);
      CdaDynamicProperty(ScrollAnimation, ListItemAnimationTypeType);
      CdaDynamicPropertyDefaultValue(GetListItemAnimationTypeDefault());
      CdaDynamicPropertyDescription("The type of the animation set for a list item.")
      CdaDynamicPropertyEnd();
      CdaDynamicPropertiesEnd();
};


#endif
