/* ***************************************************************************************
* FILE:          ListItemAnimationDynamicPropertyHost.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListItemAnimationDynamicPropertyHost is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "ListItemAnimationDynamicPropertyHost.h"


using namespace Candera;


void ListItemAnimationDynamicPropertyHost::SetListItemAnimationType(const Candera::Animation::AnimationPlayer::SharedPointer& animation, ListItemAnimationTypeType val)
{
   if (!animation.PointsToNull())
   {
      static_cast<void>(animation->SetValue(CdaDynamicPropertyInstance(ScrollAnimation), val));
   }
}


bool ListItemAnimationDynamicPropertyHost::IsListItemAnimationOfType(const Candera::Animation::AnimationPlayer::SharedPointer& animation, ListItemAnimationTypeType val)
{
   return val == GetListItemAnimationType(animation);
}


ListItemAnimationDynamicPropertyHost::ListItemAnimationTypeType ListItemAnimationDynamicPropertyHost::GetListItemAnimationType(const Candera::Animation::AnimationPlayer::SharedPointer& animation)
{
   ListItemAnimationTypeType t(LIANone);
   if (!animation.PointsToNull())
   {
      t = animation->GetValue(CdaDynamicPropertyInstance(ScrollAnimation));
   }

   return t;
}


const ListItemAnimationDynamicPropertyHost::ListItemAnimationTypeType& ListItemAnimationDynamicPropertyHost::GetListItemAnimationTypeDefault()
{
   static ListItemAnimationTypeType defaultType(LIANone);
   return defaultType;
}
