/* ***************************************************************************************
* FILE:          FlexScrollable.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexScrollable is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Flex_Scrollable_H
#define Flex_Scrollable_H

#include <FeatStd/Platform/Types.h>
#include <Candera/Macros.h>
#include "OverscrollerListener.h"

namespace Candera {
class Widget2D;
}


FEATSTD_LINT_FILE(967, FlexScrollable.h, "false positive - file has valid include guards.")

#define ENUM_DATA_TYPE \
   ENUM_DATA_TYPE_BEGIN(ListScrollingOrientation)    \
   ENUM_DATA_TYPE_ITEM(Horizontal)  \
   ENUM_DATA_TYPE_ITEM(Vertical)   \
   ENUM_DATA_TYPE_END(ListScrollingOrientation)
CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(451, "Defining enum with MetaInfo.")
#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ListScrollingType)    \
    ENUM_DATA_TYPE_ITEM(DefaultScrolling)  \
    ENUM_DATA_TYPE_ITEM(CircularScrolling)   \
    ENUM_DATA_TYPE_ITEM(LastPageNotFilled)   \
    ENUM_DATA_TYPE_END(ListScrollingType)
CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(451, "Defining enum with MetaInfo.")
#include <Candera/System/MetaInfo/EnumDataType.h>


class FlexScrollableListener : public OverscrollerListener
{
   public:
      virtual ~FlexScrollableListener() { };

      /**
       * This is called when the scrollable has reached the position it was requested
       */
      virtual void OnPositionReached() { }

      /**
       * Should be called when the content of the scrollable was updated(moved or changed)
       */
      virtual void OnContentUpdated() { }
};


class FlexScrollable
{
   public:
      virtual ~FlexScrollable() {} // dummy for lint 1510

      /**
      * Depending on @param active, it requests to activate(active = true) or deactivate(active = false)
      * immediate positioning. Immediate positioning means that no animation should be used to scroll to
      * the requested position
      */
      virtual void RequestImmediatePositioning(bool active) = 0;

      /**
       * @return true if a scrollbar should be visible; false otherwise
       */
      virtual bool IsScrollBarVisible() = 0;

      /**
       * @return the position of the first displayed entity.
       */
      virtual FeatStd::UInt32 GetPosition() = 0;

      /**
      * @return the position of the first fully visible entity.
      */
      virtual FeatStd::UInt32 GetFirstFullyVisiblePosition() = 0;

      /**
       * @return the size of the viewing window for the content.
       */
      virtual FeatStd::UInt32 GetVisibleSize() = 0;

      /**
       * @return the complete size of the content that is to be displayed.
       */
      virtual FeatStd::UInt32 GetCompleteSize() = 0;

      /**
       * @return the widget implementing this interface.
       */
      virtual Candera::Widget2D* GetWidget() = 0;

      /**
       * @return the maximum position that is allowed for the scrollable to scroll to.
       */
      virtual FeatStd::UInt32 GetMaxPosition() = 0;

      virtual bool IsCircular() = 0;

      virtual const ::Candera::ListScrollingOrientation& GetScrollingOrientation() const = 0;
      virtual void SetListener(FlexScrollableListener* listener) = 0;
};


#endif
