/* ***************************************************************************************
* FILE:          EventHub.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EventHub is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef EVENT_HUB_H
#define EVENT_HUB_H

#include <FeatStd/Base.h>

class EventHub
{
   public:
      class Event
      {
         protected:
            Event() { }
            virtual ~Event() { }

         private:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(Event);
      };

      typedef void(*EventCallback)(const Event& event);

      static void SetEventCallback(EventCallback eventCallback);

      static void Notify(const Event& event);
};


#endif
