/* ***************************************************************************************
* FILE:          EventHub.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EventHub is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "EventHub.h"
#include <FeatStd/Util/StaticObject.h>

static EventHub::EventCallback& ControlTemplateCloningStrategyEventCallback()
{
   FEATSTD_UNSYNCED_STATIC_OBJECT(EventHub::EventCallback, s_ControlTemplateCloningStrategyEventCallback);
   return s_ControlTemplateCloningStrategyEventCallback;
}


void EventHub::SetEventCallback(EventHub::EventCallback eventCallback)
{
   ControlTemplateCloningStrategyEventCallback() = eventCallback;
}


void EventHub::Notify(const EventHub::Event& event)
{
   if (0 != ControlTemplateCloningStrategyEventCallback())
   {
      ControlTemplateCloningStrategyEventCallback()(event);
   }
}
