/* ***************************************************************************************
* FILE:          CTIAnimations.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CTIAnimations is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CTIAnimations_H
#define CTIAnimations_H

#include "Candera/EngineBase/Animation/AnimationTimeType.h"

class AnimationsContainer
{
   public:
      enum PlaybackDirection
      {
         ForwardPlayback,
         ReversePlayback
      };

      virtual ~AnimationsContainer() { }

      /**
       * Stores the world time
       */
      virtual void SetWorldTime(Candera::Animation::WorldTimeType worldTime) = 0;

      /**
       * Dispatches the previously stored worldTime internally to the animation players
       */
      virtual void DispatchWorldTime() = 0;

      /**
       * Starts the contained animations
       */
      virtual bool Start(PlaybackDirection direction) = 0;

      /**
       * Returns if whether at least one of the inner animations is running
       */
      virtual bool AreRunning() const = 0;

      virtual bool ToBegin() = 0;
      virtual bool ToEnd() = 0;
};


#endif
