/* ***************************************************************************************
* FILE:          ComboBoxWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ComboBoxWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ComboBox_Widget_2D_H
#define ComboBox_Widget_2D_H

#include <Widgets/2D/ComboBox/generated/ComboBoxWidget2DBase.h>

namespace hmibase {
namespace widget {
namespace combobox {

class ComboBoxWidget2D : public ComboBoxWidget2DBase
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(ComboBoxWidget2D, ComboBoxWidget2DBase);

      /*****************************************************************************/
      ComboBoxWidget2D();
      virtual ~ComboBoxWidget2D();

      virtual void Update() override;
      virtual bool OnMessage(const Courier::Message& msg) override;
      virtual void OnChanged(Courier::UInt32 propertyId) override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;
      virtual bool OnTouch(const Candera::Camera2D& camera, const Candera::Vector2& touchedPoint) override;

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(ComboBoxWidget2D, ComboBoxWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      class ComboBoxLayouter : public Candera::OverlayLayouter
      {
         public:
            ComboBoxLayouter() : _comboboxWidget(NULL), _arrangeHeight(0.0f)
            { }

            void SetComboBoxWidget(ComboBoxWidget2D* listWidget)
            {
               _comboboxWidget = listWidget;
            }

            void SetMeasureHeight(Candera::Float height)
            {
               _arrangeHeight = height;
            }

            Candera::Float GetMeasureHeight() const
            {
               return _arrangeHeight;
            }

         protected:
            virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override;
            virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override;

         private:
            ComboBoxWidget2D* _comboboxWidget;
            Candera::Float _arrangeHeight;
      } _comboboxLayouter;

   private:

      void UpdateContentVisibility();
      bool OnComboBoxReqMsg(const ComboBoxReqMsg& msg);
      bool OnListStatusUpMsg(const ListStatusUpdMsg& msg);
      bool OnButtonReactionMsg(const ButtonReactionMsg& msg);
      void PostComboBoxUpdMsg();

      void SearchChildList();
      bool _isOpen;
      bool _invalid;
      friend class ComboBoxLayouter;
      FeatStd::UInt32 _comboBoxListId;
      FeatStd::UInt16 _listIdIterator;
};


} //namespace combobox
} //namespace widget
} //namespace hmibase

#endif
