/* ***************************************************************************************
* FILE:          ColorBarWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TempWidgets2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _COLORBAR_WIDGET_2D_H
#define _COLORBAR_WIDGET_2D_H

#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include "Widgets/2D/ColorBar/generated/ColorBarWidget2DBase.h"
#include "Widgets/2D/ColorBar/generated/ColorBarMessages.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Candera/EngineBase/Common/Bitmap.h"

class ColorBarWidget2D : public ColorBarWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ColorBarWidget2D, ColorBarWidget2DBase);

      ColorBarWidget2D();
      virtual ~ColorBarWidget2D();

      virtual void InitWidget();
      virtual bool OnMessage(const Courier::Message& msg);
      virtual void OnChanged(Candera::UInt32 propertyId);
      virtual void Update();
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:
      bool updateBarImage();
      Candera::UInt32 getLength() const;
      Candera::UInt32 getItemCount() const;

      FeatStd::UInt8* _u8Buffer;
      Candera::UInt32 _u32BuffSize;
      Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> _image2dPtr;
      Candera::MemoryManagement::SharedPointer<Candera::Bitmap> _bitmapPtr;
      bool _bInvalid;

      /*****************************************************************************/
      /* Properties */

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(ColorBarWidget2D, ColorBarWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
      /*****************************************************************************/
};


#endif // _COLORBAR_WIDGET_2D_H
