/* ***************************************************************************************
* FILE:          CanvasLayouterWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CanvasLayouterWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "Widgets/2D/Common/NodeHelper.h"
#include "Widgets/2D/List/Layouting/FlexCanvasLayouter.h"

#include "CanvasLayouterWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(CanvasLayouterWidget2D);


CanvasLayouterWidget2D::CanvasLayouterWidget2D() : _invalid(true)
{
}


CanvasLayouterWidget2D::~CanvasLayouterWidget2D()
{
}


bool CanvasLayouterWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const CanvasLayouterWidget2D* original = CLONEABLE_WIDGET_CAST<const CanvasLayouterWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());
      SetLayoutChildren(original->GetLayoutChildren());

      cloned = true;
   }
   return cloned;
}


void CanvasLayouterWidget2D::Update()
{
   if (_invalid && (0 != GetNode()) && (0 != GetNode()->GetScene()))
   {
      Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
      if (0 != node)
      {
         node->SetLayouter(FlexCanvasLayouter::GetInstance());
         FlexCanvasLayouter::SetLayoutChildren(*node, GetLayoutChildren());
         InvalidateLayout();
         Invalidate();
      }
      _invalid = false;
   }
}


void CanvasLayouterWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);
   _invalid = true;
}


void CanvasLayouterWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}
