/* ***************************************************************************************
* FILE:          CameraControlWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CameraControlWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "CameraControlWidget2D.h"

#include <View/CGI/CgiExtensions/TouchInput.h>

#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_NODECONTROL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CameraControlWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(CameraControlWidget2D);


/*****************************************************************************/
CameraControlWidget2D::CameraControlWidget2D() : Base(), _viewportChanged(false)
{
}


/*****************************************************************************/
CameraControlWidget2D::~CameraControlWidget2D()
{
}


/*****************************************************************************/
void CameraControlWidget2D::OnChanged(::FeatStd::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   switch (propertyId)
   {
      case ViewportPropertyId:
         _viewportChanged = true;
         break;

      case UseForTouchPropertyId:
         if (GetUseForTouchEnabled())
         {
            Candera::Camera2D* camera = Candera::Dynamic_Cast<Candera::Camera2D*>(GetNode());
            if (camera != NULL)
            {
               hmibase::input::SetUseCameraForTouch(camera, GetUseForTouch());
            }
         }
         break;

      default:
         break;
   }
}


/*****************************************************************************/
void CameraControlWidget2D::Update()
{
   Candera::Camera2D* camera = Candera::Dynamic_Cast<Candera::Camera2D*>(GetNode());
   if ((camera != NULL) && _viewportChanged)
   {
      _viewportChanged = false;

      if (GetViewportEnabled())
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update viewport=%24s camera=%50s %s",
                             HMIBASE_TO_STRING(GetViewport()),
                             HMIBASE_TO_STRING_N2D(camera),
                             HMIBASE_TO_STRING_VW(this)));

         camera->SetViewport(GetViewport());
         Candera::Renderer2D::RenderCamera(camera);
      }
   }
}


/*****************************************************************************/
bool CameraControlWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const CameraControlWidget2D* original = CLONEABLE_WIDGET_CAST<const CameraControlWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetViewportEnabled(original->GetViewportEnabled());
      SetViewport(original->GetViewport());
      SetUseForTouchEnabled(original->GetUseForTouchEnabled());
      SetUseForTouch(original->GetUseForTouch());

      cloned = true;
   }
   return cloned;
}
