/* ***************************************************************************************
* FILE:          ButtonTextColorWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonTextColorWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ButtonTextColor_WIDGET2D_H
#define ButtonTextColor_WIDGET2D_H

#include "Widgets/2D/ButtonText/generated/ButtonTextWidgets2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class ButtonTextColorWidget2D : public ButtonTextColorWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ButtonTextColorWidget2D, ButtonTextColorWidget2DBase);

      ButtonTextColorWidget2D();
      virtual ~ButtonTextColorWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual hmibase::widget::appearance::AppearanceTemplate* CreateAppearanceTemplate();

   private:
      virtual void Update();
      virtual void OnChanged(::FeatStd::UInt32 propertyId);

      const Candera::Color& GetButtonStateColor() const;

      CdaWidget2DDef(ButtonTextColorWidget2D, ButtonTextColorWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
