/* ***************************************************************************************
* FILE:          ButtonTextColorWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonTextColorWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ButtonTextColorWidget2D.h"
#include "Widgets/2D/Button/ButtonWidget2D.h"
#include <Widgets/2D/Button/ButtonAppearance2D.h>
#include "Widgets/2D/Text/TextWidget2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_APPEARANCE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ButtonTextColorWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ButtonTextColorWidget2D);

ButtonTextColorWidget2D::ButtonTextColorWidget2D(): Base()
{
}


ButtonTextColorWidget2D::~ButtonTextColorWidget2D()
{
}


void ButtonTextColorWidget2D::OnChanged(::FeatStd::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   switch (propertyId)
   {
      case OutlineColorConfigurationPropertyId:
      case NormalTextColorPropertyId:
      case PressedTextColorPropertyId:
      case DisabledTextColorPropertyId:
      case PressedDisabledTextColorPropertyId:
      case ActiveNormalTextColorPropertyId:
      case ActivePressedTextColorPropertyId:
      case ActiveDisabledTextColorPropertyId:
      case ActivePressedDisabledTextColorPropertyId:
      case FocusedNormalTextColorPropertyId:
      case FocusedPressedTextColorPropertyId:
      case FocusedDisabledTextColorPropertyId:
      case FocusedPressedDisabledTextColorPropertyId:
      case FocusedActiveNormalTextColorPropertyId:
      case FocusedActivePressedTextColorPropertyId:
      case FocusedActiveDisabledTextColorPropertyId:
      case FocusedActivePressedDisabledTextColorPropertyId:
         SetInvalid(true);
         break;

      default:
         break;
   }
}


const Candera::Color& ButtonTextColorWidget2D::GetButtonStateColor() const
{
   switch (GetButtonState().asEnum())
   {
      default:
      case AppearanceState::enNormal:
         return GetNormalTextColor();

      case AppearanceState::enPressed:
         return GetPressedTextColor();
      case AppearanceState::enDisabled:
         return GetDisabledTextColor();
      case AppearanceState::enPressedDisabled:
         return GetPressedDisabledTextColor();

      case AppearanceState::enActiveNormal:
         return GetActiveNormalTextColor();
      case AppearanceState::enActivePressed:
         return GetActivePressedTextColor();
      case AppearanceState::enActiveDisabled:
         return GetActiveDisabledTextColor();
      case AppearanceState::enActivePressedDisabled:
         return GetActivePressedDisabledTextColor();

      case AppearanceState::enFocusedNormal:
         return GetFocusedNormalTextColor();
      case AppearanceState::enFocusedPressed:
         return GetFocusedPressedTextColor();
      case AppearanceState::enFocusedDisabled:
         return GetFocusedDisabledTextColor();
      case AppearanceState::enFocusedPressedDisabled:
         return GetFocusedPressedDisabledTextColor();

      case AppearanceState::enFocusedActiveNormal:
         return GetFocusedActiveNormalTextColor();
      case AppearanceState::enFocusedActivePressed:
         return GetFocusedActivePressedTextColor();
      case AppearanceState::enFocusedActiveDisabled:
         return GetFocusedActiveDisabledTextColor();
      case AppearanceState::enFocusedActivePressedDisabled:
         return GetFocusedActivePressedDisabledTextColor();
   }
}


bool ButtonTextColorWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ButtonTextColorWidget2D* original = CLONEABLE_WIDGET_CAST<const ButtonTextColorWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetOutlineColorConfiguration(original->GetOutlineColorConfiguration());

      SetNormalTextColor(original->GetNormalTextColor());
      SetPressedTextColor(original->GetPressedTextColor());
      SetDisabledTextColor(original->GetDisabledTextColor());
      SetPressedDisabledTextColor(original->GetPressedDisabledTextColor());

      SetActiveNormalTextColor(original->GetActiveNormalTextColor());
      SetActivePressedTextColor(original->GetActivePressedTextColor());
      SetActiveDisabledTextColor(original->GetActiveDisabledTextColor());
      SetActivePressedDisabledTextColor(original->GetActivePressedDisabledTextColor());

      SetFocusedNormalTextColor(original->GetFocusedNormalTextColor());
      SetFocusedPressedTextColor(original->GetFocusedPressedTextColor());
      SetFocusedDisabledTextColor(original->GetFocusedDisabledTextColor());
      SetFocusedPressedDisabledTextColor(original->GetFocusedPressedDisabledTextColor());

      SetFocusedActiveNormalTextColor(original->GetFocusedActiveNormalTextColor());
      SetFocusedActivePressedTextColor(original->GetFocusedActivePressedTextColor());
      SetFocusedActiveDisabledTextColor(original->GetFocusedActiveDisabledTextColor());
      SetFocusedActivePressedDisabledTextColor(original->GetFocusedActivePressedDisabledTextColor());

      cloned = true;
   }
   return cloned;
}


void ButtonTextColorWidget2D::Update()
{
   Base::Update();

   TextWidget2D* textWidget = GetTextWidget();
   if (textWidget != NULL)
   {
      const Candera::Color& color = GetButtonStateColor();

      if (GetOutlineColorConfiguration())
      {
         if (textWidget->GetOutlineColor() != color)
         {
            textWidget->SetOutlineColor(color);
            textWidget->Invalidate();
         }
      }
      else
      {
         //temporary check until the text widget is fixed to update the color correctly
         Candera::RenderNode* textNode = Candera::Dynamic_Cast<Candera::RenderNode*>(textWidget->GetNode());
         if ((textNode != NULL) && (textNode->GetEffect(0) != NULL))
         {
            Candera::TextBrush* textBrush = Candera::Dynamic_Cast<Candera::TextBrush*>(textNode->GetEffect(0)->GetBrushEffect2D());
            if ((textBrush != NULL) && (Candera::Color(textBrush->Color().Get()) != color))
            {
               textWidget->SetTextColor(Candera::Color(textBrush->Color().Get()));
               textWidget->SetTextColor(color);
               textWidget->Invalidate();
            }
         }

         //if (textWidget->GetTextColor() != color)
         //{
         //   textWidget->SetTextColor(color);
         //   textWidget->Invalidate();
         //}
      }

      SetInvalid(false);
   }
}


using namespace hmibase::widget::appearance;
hmibase::widget::appearance::AppearanceTemplate* ButtonTextColorWidget2D::CreateAppearanceTemplate()
{
   AppearanceColorData::SharedPointer buttonColorData = AppearanceColorData::create(GetNormalTextColor(), GetPressedTextColor(), GetDisabledTextColor(), GetActiveNormalTextColor(), GetActivePressedTextColor(), GetActiveDisabledTextColor(),
         GetFocusedNormalTextColor(), GetFocusedPressedTextColor(), GetFocusedDisabledTextColor(), GetFocusedActiveNormalTextColor(), GetFocusedActivePressedTextColor(), GetFocusedActiveDisabledTextColor());
   return FEATSTD_NEW(ColorAppearanceTemplate)(buttonColorData);
}
